<?php
/*
 BMForum Forums Systems
 Rev. 11:54 2006-6-17
 
 This is a freeware, but don't change the copyright information.
 A SourceForge Project.
 Web Site: http://www.bmforum.com
 Copyright (C) Bluview Technology
 
 New Template Engine for BMForum
*/
function newtemplate($files, $temfilename, $styleidcode, $lang_zone, $nest = 4, $plugins = 0)
{
    global $template, $template_filename, $template_html_content, $cachedstyle, $template_content,  $language, $openstylereplace;
    $template_name_php = $plugins ? "datafile/cache/themes/$styleidcode/$files-p-$temfilename-$language-$openstylereplace.php" : "datafile/cache/themes/$styleidcode/$files-$language-$openstylereplace.php";
    
    if (!file_exists($template_name_php) || $cachedstyle == 0) {
    	$file = $plugins ? "plugins/templates/$temfilename/$files.htm" : "newtem/$temfilename/$files.htm";
    	if (!file_exists($file)) {
    		$file = $plugins ? "plugins/templates/bsd01/$files.htm" : "newtem/bsd01/$files.htm";
    	}
    	$cache = 0;
    } else {
    	$file = $template_name_php;
    	$cache = 1;
    }
    $template = readfromfile($file);
    if ($cache == 0) {
		$template_html_content = $template;
    } else {
        $template_content = readfromfile($file);
    } 
    $template_filename = $file;
    if ($cache == 0){
	    $wrtingcaches = nsubst($lang_zone, $nest);
	    writetofile($template_name_php, $wrtingcaches);
    }
    
    return $template_name_php;
} 
function set_var($tvars, $template_content)
{
	foreach($tvars as $tkey => $tvalue) {
	    if (is_array($tvalue)) {
	        foreach ($tvalue as $key => $value) {
	            $template_content = str_replace("{" . $tkey . "[" . $key . "]}", $value, $template_content);
	        } 
	    } else {
	    	$template_content = str_replace("{" . $tkey ."}", $tvalue, $template_content);
	    }
    }
    return $template_content;
} 
function i_template($template){
	global $temfilename, $styleidcode, $lang_zone;
	if ($template == "header") return "header.php";
	if ($template == "footer") return "footer.php";
    return newtemplate($template, $temfilename, $styleidcode, $lang_zone);
}
function nsubst($lang_zone, $nest)
{
    global $template_html_content, $template_content;
    
    $value = $template_html_content;
    
    if (is_array($lang_zone)) $value = set_var($lang_zone, $value);

	$var_regexp = "((\\\$[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)(\[[a-zA-Z0-9_\-\.\"\'\[\]\$\x7f-\xff]+\])*)";
	$const_regexp = "([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)";
	
	$value = preg_replace("/([\n\r]+)\t+/s", "\\1", $value);
	$value = preg_replace("/\<\!\-\-\{(.+?)\}\-\-\>/s", "{\\1}", $value);
	$value = str_replace("{LF}", "<?php echo \"\\n\";?>", $value);

	$value = preg_replace("/\{(\\\$[a-zA-Z0-9_\[\]\'\"\$\.\x7f-\xff]+)\}/s", "<?php echo \\1;?>", $value);
	$value = preg_replace("/$var_regexp/es", "addquote('<?php echo \\1;?>')", $value);
	$value = preg_replace("/\<\?php echo <\?php echo $var_regexp\;\?\>\;\?\>/es", "addquote('<?php echo \\1;?>')", $value);


	$value = preg_replace("/[\n\r\t]*\{template\s+([a-z0-9_]+)\}[\n\r\t]*/is", "\n<?php include i_template('\\1'); ?>\n", $value);
	$value = preg_replace("/[\n\r\t]*\{template\s+(.+?)\}[\n\r\t]*/is", "\n<?php include i_template(\\1); ?>\n", $value);
	$value = preg_replace("/[\n\r\t]*\{eval\s+(.+?)\}[\n\r\t]*/ies", "stripvtags('\n<?php \\1 ?>\n','')", $value);
	$value = preg_replace("/[\n\r\t]*\{echo\s+(.+?)\}[\n\r\t]*/ies", "stripvtags('<?php echo \\1; ?>','')", $value);
	$value = preg_replace("/[\n\r\t]*\{elseif\s+(.+?)\}[\n\r\t]*/ies", "stripvtags('\n<?php } elseif(\\1) { ?>\n','')", $value);
	$value = preg_replace("/[\n\r\t]*\{else\}[\n\r\t]*/is", "\n<?php } else { ?>\n", $value);

	for($i = 0; $i < $nest; $i++) {
		$value = preg_replace("/[\n\r\t]*\{loop\s+\<\?php echo (\S+);\?\>\s+\<\?php echo (\S+);\?\>\}[\n\r]*(.+?)[\n\r]*\{\/loop\}[\n\r\t]*/ies", "stripvtags('\n<?php if(is_array(\\1)) { foreach(\\1 as \\2) { ?>','\n\\3\n<?php } } ?>\n')", $value);
		$value = preg_replace("/[\n\r\t]*\{loop\s+\<\?php echo (\S+);\?\>\s+\<\?php echo (\S+);\?\>\s+\<\?php echo (\S+);\?\>\}[\n\r\t]*(.+?)[\n\r\t]*\{\/loop\}[\n\r\t]*/ies", "stripvtags('\n<?php if(is_array(\\1)) { foreach(\\1 as \\2 => \\3) { ?>','\n\\4\n<?php } } ?>\n')", $value);
		$value = preg_replace("/[\n\r\t]*\{if\s+(.+?)\}[\n\r]*(.+?)[\n\r]*\{\/if\}[\n\r\t]*/ies", "stripvtags('\n<?php if(\\1) { ?>','\n\\2\n<?php } ?>\n')", $value);
	}
	$value = preg_replace("/\{$const_regexp\}/s", "<?php echo \\1;?>", $value);
	$value = preg_replace("/ \?\>[\n\r]*\<\?php /s", " ", $value);
	
	$value = "<?php if (!defined('INBMFORUM')) die(\"Access Denied\"); ?>\n".$value;

    $template_content = $returns = $value;


    return $returns;
} 
function addquote($var) {
	return str_replace("\\\"", "\"", preg_replace("/\[([a-zA-Z0-9_\-\.\x7f-\xff]+)\]/s", "['\\1']", $var));
}
function stripvtags($expr, $statement) {
	$expr = str_replace("\\\"", "\"", preg_replace("/\<\?php echo (\\\$.+?);\?\>/s", "\\1", $expr));
	$statement = str_replace("\\\"", "\"", $statement);
	return $expr.$statement;
}