<%
Class [Case]  'Extends bbs--Top
	private tableName,orderStr,auditStatus
	sub initialize
		tableName = "self_GuestTopic"
		that.d("layuicachepage") = "case"
		if S_("adminId") <> "" then
			that.d("mycaseUrl") = "?case_user_" & S_("adminId")
		else
			that.d("mycaseUrl") = getLoginUrl()
		end if
	end sub
	
	'显示所有案例
	'所有用户都可以查看
	sub index
		dim obj,where,rs,theYear
		set obj = objCMS
		
		theYear = that.get("id")
		
		if not isDate( theYear & "-1-1" ) then
			theYear = ""
		end if
		
		if theYear = "" then
			theYear = year( now() )
			
			POP_MVC.get("id") = theYear
		end if
		
		set where = D_
				
		where("SortID") = POP_MVC.config("BBS_CASE_SORTID")
		if C_("DB_TYPE") = "sqlite3" then
			where( "strftime('%Y',AddTime) = '" & theYear & "'" ) = null
		else
			where( "year(AddTime)" ) = theYear
		end if
		
		where( "a.UserID = b.UserID" ) = null
		where( "ContentStatus" ) = 1
		
		if orderStr = "" then
			orderStr = "TopicID DESC"
		end if
		
		set rs = B_("self_GuestConfig").from("{prefix}self_GuestTopic as a,{prefix}User as b").onlysql(0).order(orderStr).field("TopicID,Title,Content,a.AddTime,a.UserID,ZanCount,CaiCount,a.IndexImage,a.ContentSource,b.LoginName,b.Nickname").page("null,20").where( where ).select

		that.d("case") = rs
		
		that.d("arrYear") = POP_MVC.arr.range( year( now() ) ,2016 )
		that.d("theYear") = theYear
		that.d("curYear") = year(now)
		
		templatePath= obj.getTemplatePath( "case/case" )
		obj.load(templatePath)	
		obj.parseHtml	
		objCMS.output
	end sub
	
	'显示某个用户提交的案例
	'仅管理员与自已可以查看
	sub user
		dim obj,where,rs,userId,theYear
		set obj = objCMS
		
		userId = that.get("id")
		
		if S_("IsAdmin") <> 1 AND UserID - S_("adminId") <> 0 then
			that.error("您无权查看该页面")
		end if
		
		theYear = year( now() )
	
		set where = D_
				
		where("SortID") = POP_MVC.config("BBS_CASE_SORTID")

		where( "a.UserID = b.UserID" ) = null
		where( "a.UserID" ) = userId
		
		if orderStr = "" then
			orderStr = "TopicID DESC"
		end if
		
		set rs = B_("self_GuestConfig").from("{prefix}self_GuestTopic as a,{prefix}User as b").onlysql(0).order(orderStr).field("TopicID,Title,Content,a.AddTime,a.UserID,ZanCount,CaiCount,a.IndexImage,a.ContentSource,b.LoginName,b.Nickname").page("null,20").where( where ).select

		that.d("case") = rs
		that.d("theYear") = theYear
		
		templatePath= obj.getTemplatePath( "case/user" )
		obj.load(templatePath)	
		obj.parseHtml	
		objCMS.output
	end sub	
	
	'按点赞排行显示案例
	sub ranking
		orderStr = "ZanCount DESC"
		Call index
	end sub
	
	'显示指定年份的所有案例
	'仅管理员有查看及操作权限
	'未指定年份取今年数据
	sub audit
		if S_("IsAdmin") <> 1 then
			that.error("您无权查看该页面")
		end if
	
		dim obj,where,rs,theYear
		set obj = objCMS
		
		theYear = that.get("id")
		
		if not isDate( theYear & "-1-1" ) then
			theYear = ""
		end if
		
		if theYear = "" then
			theYear = year( now() )			
			POP_MVC.get("id") = theYear
		end if
		
		set where = D_
				
		where("SortID") = POP_MVC.config("BBS_CASE_SORTID")
		if C_("DB_TYPE") = "sqlite3" then
			where( "strftime('%Y',AddTime) = '" & theYear & "'" ) = null
		else
			where( "year(AddTime)" ) = theYear
		end if
		where( "a.UserID = b.UserID" ) = null
		if not isEmpty( auditStatus ) then
			where( "a.ContentStatus" ) = auditStatus
		end if
		
		if orderStr = "" then
			orderStr = "ContentStatus ASC,TopicID DESC"
		end if
		
		set rs = B_("self_GuestConfig").from("{prefix}self_GuestTopic as a,{prefix}User as b").onlysql(0).order(orderStr).field("a.TopicID,a.Title,Content,a.AddTime,a.ContentStatus,a.UserID,ZanCount,CaiCount,a.IndexImage,a.ContentSource,b.LoginName,b.Nickname").page("null,20").where( where ).select

		that.d("case") = rs
		
		that.d("arrYear") = POP_MVC.arr.range( year( now() ) ,2016 )
		that.d("theYear") = theYear
		that.d("curYear") = year(now)
		
		templatePath= obj.getTemplatePath( "case/audit" )
		obj.load(templatePath)	
		obj.parseHtml	
		objCMS.output
	end sub
	
	sub find
		if S_("IsAdmin") <> 1 then
			that.error("您无权查看该页面")
		end if
	
		dim obj,where,rs,dict
		set obj = objCMS
		
		set where = D_
				
		where("SortID") = POP_MVC.config("BBS_CASE_SORTID")
		where("a.TopicID") = that.req("id")
		
		set dict = B_("self_GuestConfig").from("{prefix}self_GuestTopic as a,{prefix}User as b").onlysql(0).order(orderStr).field("a.TopicID,a.Title,Content,a.AddTime,a.ContentStatus,a.UserID,ZanCount,CaiCount,a.IndexImage,a.ContentSource,b.LoginName,b.Nickname").where(where).getRow
		dict("status") = that.ajaxSuccessStatus
		that.ajaxData(dict)
	end sub
	
	'显示未审核案例
	sub audit0
		auditStatus = 0
		Call audit
	end sub
	
	'显示通过审核案例
	sub audit1
		auditStatus = 1
		Call audit
	end sub
	
	'显示已拒绝案例
	sub audit2
		auditStatus = 2
		Call audit
	end sub
	
	sub test
		var_Export P_("http").isInstall
	end sub
	
end Class
%>