<%
Class FileTool
	public countnum,xmlDomObj
	Private redundancy_table,redundancy_file,empty_table,empty_file
	Private plut_str,allTables
	
	Private Sub Class_Initialize
		countnum = 0
	end sub
	
	Private Sub Class_Terminate
		if isObject( xmlDomObj ) then set xmlDomObj = nothing
	end sub
	
	sub flushStart()
		response.write "<center>正在检测冗余文件，检测时间可能有点长，请耐心等待……</center>"
		response.flush
	end sub
	
	sub emptyStart()
		response.write "<center>正在检测空文件夹，请耐心等待……</center>"
		response.flush
	end sub	
	
	sub flushEach( path ,size )
		response.write "<center>检测到第" & countnum & "个冗余文件 <a href='" & path & "' target='_blank'>" & path & "</a>  " & size & "</center>"
		response.flush
	end sub
	
	sub emptyEach( path ,size )
		response.write "<center>检测到第" & countnum & "个空文件 <a href='" & path & "' target='_blank'>" & path & "</a>  " & size & "</center>"
		response.flush
	end sub
	
	sub flushEnd()
		response.write "<center>已检测完毕，共发现" & countnum & "个冗余文件，3秒后自动关闭当前页面！<script>setTimeout(function(){parent.location.reload();try{window.close();}catch( err ) {window.open('','_self').close();}finally{window.open('about:blank','_self').close();}},3000);</script></center>"
		response.flush
	end sub
	
	sub emptyEnd()
		response.write "<center>已检测完毕，共发现" & countnum & "个空文件夹，3秒后自动关闭当前页面！<script>setTimeout(function(){parent.location.reload();try{window.close();}catch( err ) {window.open('','_self').close();}finally{window.open('about:blank','_self').close();}},3000);</script></center>"
		response.flush
	end sub
	
	sub file_put_redundancy
		Call POP_MVC.file_put_contents_without_bom( POP_MVC.appPath & "/runtime/redundancy/table.txt" , redundancy_table )
		Call POP_MVC.file_put_contents_without_bom( POP_MVC.appPath & "/runtime/redundancy/file.txt" , redundancy_file )
	end sub
	
	sub file_put_empty
		Call POP_MVC.file_put_contents_without_bom( POP_MVC.appPath & "/runtime/emptyFolder/table.txt" , empty_table )
		Call POP_MVC.file_put_contents_without_bom( POP_MVC.appPath & "/runtime/emptyFolder/file.txt" , empty_file )
	end sub
	
	function file_get_redundancy
		file_get_redundancy = POP_MVC.file_get_contents( POP_MVC.appPath & "/runtime/redundancy/table.txt")
	end function
	
	function file_get_empty
		file_get_empty = POP_MVC.file_get_contents( POP_MVC.appPath & "/runtime/emptyFolder/table.txt")
	end function
	
	sub file_redundancy_remove
		Call POP_MVC.file.remove( POP_MVC.appPath & "/runtime/redundancy/" )
	end sub
	
	sub file_empty_remove
		Call POP_MVC.file.remove( POP_MVC.appPath & "/runtime/emptyFolder/" )
	end sub
	
	Function redundancy()
		Call flushStart
		redundancy_table = ""
		allTables = B_("self_GuestConfig").getAllTables

		call POP_MVC.File.files_map( C_("CMS_UPLOAD_PATH") , "K_(""bbs--FileTool"").redundancyFile")	
		
		if redundancy_table = "" then
			redundancy_table = "<tr><td colspan=5>没有冗余文件</td></tr>"
		end if
		
		redundancy_table = "<div class='layui-form'><table class='layui-table'><thead><tr><th>序号</th><th>文件名称</th><th>大小</th><th>类型</th><th>修改日期</th></tr></thead><tbody>" & redundancy_table	& "</tbody></table></div>"
		redundancy =redundancy_table
		Call file_put_redundancy
		Call flushEnd
	End Function
	
	'空文件夹检测
	Function emptyfolder()
		Call emptyStart
		empty_table = ""
		call POP_MVC.File.folders_map( C_("CMS_UPLOAD_PATH") , "K_(""bbs--FileTool"").emptyfolder_")	
		
		if empty_table = "" then
			empty_table = "<tr><td colspan=5>没有空文件夹了</td></tr>"
		end if
		
		empty_table = "<div class='layui-form'><table class='layui-table'><thead><tr><th>序号</th><th>文件名称</th><th>大小</th><th>类型</th><th>修改日期</th></tr></thead><tbody>" & empty_table	& "</tbody></table></div>"
		emptyfolder = empty_table
		Call file_put_empty
		Call emptyEnd		
		
		
	End Function
	
	'回调函数，冗余文件处理
	sub redundancyFile( file )
		on error resume next
		dim path,size,filetype,extname
		filetype=POP_MVC.file.getFileType(file.path)
		path = mid( file.path,len(POP_MVC.realpath("./"))+2  )

		path = replace(path,"\" , "/")
		extname = LCase(Mid(file.name, InStrRev(file.name, ".") + 1))

		if not needRedundancy( path ) then
			exit sub
		end if
		
		size = byte2size(file.size)	
		countnum = countnum + 1	

		Call flushEach( path,size )
			if not isEmpty( redundancy_file ) then
				redundancy_file = redundancy_file & "," & path
			else
				redundancy_file = path
			end if
			
			redundancy_table = redundancy_table & "<tr>"
			redundancy_table = redundancy_table & "<td>" & countnum & "</td>"
			redundancy_table = redundancy_table & "<td style='text-align:left'>"

			redundancy_table = redundancy_table & "<a target='_blank' href='" & path & "'>"
			redundancy_table = redundancy_table & "<img border=0 width='20' height='20' src='./" & POP_MVC.config("STATIC_NAME") & "/images/icon/" & extname &  ".gif' />&nbsp;"
			redundancy_table = redundancy_table & file.name
			if filetype="img" then
				redundancy_table = redundancy_table & "</a>"
			end if
			redundancy_table = redundancy_table & "</td>"
			redundancy_table = redundancy_table & "<td>" & size & "</td>"
			redundancy_table = redundancy_table & "<td>" & extname & "</td>"
			redundancy_table = redundancy_table & "<td>"& file.DateLastModified & "</td>"
			redundancy_table = redundancy_table & "</tr>" & vbcrlf
	end sub
	
	'是否为冗余文件
	Function needRedundancy( path )
		dim fields,rs
		needRedundancy = false
		fields = "IndexImage,DownURL,Content,ContentSource"
		set rs = B_( "self_GuestTopic" ).field("TopicID").top(1).search( path,fields)
		if not rs.eof then
			rs.close : set rs = nothing : exit Function
		end if
		
		fields = "Avatar,Address"
		set rs = B_( "User" ).field("UserID").top(1).search( path,fields)		
		if not rs.eof then
			rs.close : set rs = nothing : exit Function
		end if
		rs.close : set rs = nothing
		
		set rs = B_("self_GuestConfig").field("ConfigID").top(1).search(path, "ConfigValue" )
		if not rs.eof then
			rs.close : set rs = nothing : exit Function
		end if
		rs.close : set rs = nothing
		
		set rs = B_( "self_GuestReply" ).field("ReplyID").top(1).search(path, "Content" )
		if not rs.eof then
			rs.close : set rs = nothing : exit Function
		end if
		rs.close : set rs = nothing

		needRedundancy = true
	End Function
	
	'从一个字段中删除多余的图片或附件
	Sub removeFileFromField( fieldValue , ByRef count )
		dim arr,item
		if not isNul( fieldValue ) then
			arr = split( fieldValue, "," )
			for each item in arr
				item = trim(item)
				if POP_MVC.file.isFile(item) then
					if needRedundancy( item ) then
						POP_MVC.file.remove( item )
						count = count + 1
					end if
				end if
			next
		end if
	End Sub	
	
	'从一个文章内容中删除多余的图片或附件
	Sub removeFileFromContent( content, ByRef count )
		dim matches,match,path
		set matches = POP_MVC.String.reg_exec( content, "(?:src|href)\s*=\s*(|'|"")(" & POP_MVC.config("CMS_UPLOAD_PATH") & ".+?)\1" , "gim" )
		for each match in matches
			path = C_("sitePath") &  match.submatches(1)
			if needRedundancy( path ) then
				POP_MVC.file.remove( path )
				count = count + 1
			end if
		next	
	End Sub	
	
	sub emptyfolder_( file )
		dim path,size,rs
		
		if file.SubFolders.count > 0 then exit sub
		
		if file.Files.count > 0 then exit sub
		
		path = mid( file.path,len(POP_MVC.realpath("./"))+1  )
		path = replace(path,"\" , "/")
						
		size = byte2size(file.size) 	
		countnum = countnum + 1		
		
		Call emptyEach( path,size )
			if not isEmpty( empty_file ) then
				empty_file = empty_file & "," & path
			else
				empty_file = path
			end if		
		
			empty_table = empty_table & "<tr>"
			empty_table = empty_table & "<td>" & countnum & "</td>"
			empty_table = empty_table & "<td style='text-align:left'>"

			empty_table = empty_table & "<img border=0 width='20' height='20' src='./" & POP_MVC.config("STATIC_NAME") & "/images/icon/folder.gif' />&nbsp;"
			empty_table = empty_table & file.name
			empty_table = empty_table & "</td>"
			empty_table = empty_table & "<td>" & size & "</td>"
			empty_table = empty_table & "<td>文件夹</td>"
			empty_table = empty_table & "<td>"& file.DateLastModified & "</td>"
			empty_table = empty_table & "</tr>" & vbcrlf

	end sub
	
	Function tempList(selectname,selectedtemp)
		dim path,fileListArray,i,fileAttr,folderListArray,folderAttr,parentPath,ret,pathlen
		path=C_("sitePath")&"/Templates/"&config.defaultTemplate&"/"&config.htmlFilePath	
		if not POP_MVC.file.isExists(path) then POP_MVC.CreateFolder(path)
		ret = ""
		ret = "<select name="""&selectname&""" id="""&selectname&""">"

		path = POP_MVC.realPath(path)
		pathlen = len(path)+2
		fileListArray = POP_MVC.file.getFilesPath(path)
		
		ret = ret & "<option value=""""" & iif( instr( fileListArray , selectedtemp ) > 0 , "" , " selected" )  & ">请选择模板</option>"
		if not POP_MVC.file.isExists(path) then	
			ret = ret & "<option value="""">未找到模版</option>"
			tempList = ret
			exit Function
		end if		
		
		dim selectedstr
		fileListArray = split(POP_MVC.file.getFilesPath(path),",")
		for  i = 0 to ubound(fileListArray)
			fileAttr = fileListArray(i)
			fileAttr = mid( fileAttr, pathlen  )
			fileAttr = replace( fileAttr, "\" , "/" )
			selectedstr=""
			if selectedtemp=fileAttr then selectedstr=" selected"
			ret = ret & "<option value="""&fileAttr &""""&selectedstr&">"&fileAttr &"</option>" & vbcrlf
		next		
		ret = ret & "</select>"
		tempList = ret
	End Function

	'回调函数，html文件进行标签替换处理
	sub aspcmsReplaceLabel( file )
		dim content,str,realPath,i,srcSort,dstSort
		path = mid( file.path,len(POP_MVC.realpath("./"))+1  )
		if POP_MVC.String.iEndsWith(file.name , config.fileExt ) then		
			content = POP_MVC.file_get_contents_charset( file.path,config.charset )
			
			'下面是替换规则
			content = POP_MVC.String.reg_replace( content, POP_MVC.config("CMS_TAG_LABEL") , "\baspcms\b" , "gim" )
			
			'写入文件
			call POP_MVC.file_put_contents_charset( file.path,content,config.charset )
			
			'刷出替换信息
			str =  "<span style='display:inline-block;width:400px;'>" & path & "</span> <a href='?c=Language&a=getPrismFile&filePath=" & file.path & "'>查看</a> | <a href='?c=Template&a=edit&filename=" & file.path & "'>编辑</a><br />"
			Response.write str
			Response.flush

		end if
	end sub	
End Class
%>