<%
Class Manage 'Extends bbs--Common
	private tableName
	sub initialize
		tableName = "User"
		that.d("layuicachepage") = "user"
		if S_("IsAdmin") <> 1 then
			that.error("您无权查看该页面")
		end if
	end sub
	
	'论坛配置
	sub Configs
		dim arr
		arr = B_("self_GuestConfigGroup").top(9).field("GroupID").order("GroupOrder asc").get1arr
		arr = join(arr,",")
		Call SetConfig(arr)
	End Sub
	
	'网站设置
	sub Configs2
		dim arr
		arr = B_("self_GuestConfigGroup").top(9).field("GroupID").order("GroupOrder Desc").get1arr
		arr = join(arr,",")
		Call SetConfig(arr)
	End Sub
	
	'取反状态字段值
	sub setStatusField
		dim id,StatusField,authInfo,FieldValue
		id = POP_MVC.req("id")
		StatusField = POP_MVC.req("StatusField")
		FieldValue = POP_MVC.req("FieldValue")
		
		authInfo = K_("bbs--Public").AuthCompare( id , "进行该项操作！" )
		
		if authInfo <> "" then
			that.error( authInfo )
		end if
		Call B_(tableName).where(id).setNot( StatusField )
		that.success("设置成功！")	
	end sub
	
	'将状态字段值设为1
	sub OpenStatusField
		dim id,StatusField
		id = POP_MVC.req("id")
		StatusField = POP_MVC.req("StatusField")
		
		Call B_(tableName).where(id).setField( StatusField , 1 )
		that.success("设置成功！")	
	end sub
	
	'将状态字段值设为0
	sub CloseStatusField
		dim id,StatusField
		id = POP_MVC.req("id")
		StatusField = POP_MVC.req("StatusField")
		
		Call B_(tableName).where(id).setField( StatusField , 0 )
		that.success("设置成功！")	
	end sub
	
	sub SuperAdminPower
		if S_("GroupID") <> 1 then	
			that.error("非超级管理员无权操作！")	
		end if
	End Sub
	
	'设为管理员
	sub OpenAdmin
		Call SetAdmin( "GroupID" , 2 )
		that.success("设置成功！")
	end sub
	
	'取消管理员
	sub CloseAdmin
		Call SetAdmin( "GroupID" , 3 )
		that.success("设置成功！")
	end sub
	
	'设置或取消管理员
	'GroupID 2为管理员；3为普通会员。
	Private Sub SetAdmin( field , value )
		Call SuperAdminPower
		dim id,IsAdmin
		id = POP_MVC.req("id")
		IsAdmin = POP_MVC.req("IsAdmin")
		Call B_(tableName).where(id).setField( field , value )	
		objCMS.clearCache		
	End Sub

	'修改配置值
	sub doEditConfigs
		Call SuperAdminPower
		dim key,dict,MailAlert
		set dict = POP_MVC.form2dict
		'set dict = K_("Plugin--Public").getAjaxData

		if dict.Exists("SiteStatus") then
			if dict("SiteStatus") = "0" then
				MailAlert = POP_MVC.String.uniqid
				Call B_("user").where("LoginName = 'admin'").setField( "MailAlert" , MailAlert )
				Call K_("bbs--mail").OpenSiteStatus( MailAlert)
				Call POP_MVC.file_put_contents( POP_MVC.config("CORE_NAME") & "/closebbs.txt" , date() )
			end if
		end if

		if dict.Exists("DefaultTemplate") then
			if dict("DefaultTemplate") <> config.defaultTemplate then
				Call K_("bbs--system").ModifyConfig("configs" , "DefaultTemplate" , dict("DefaultTemplate") )
			end if
		end if

		
		for each key in dict
			Call B_("self_GuestConfig").where( that.dict( "ConfigName" , key  ) ).setField( "ConfigValue",dict(key) )
		next

		if dict("QQ_APP_ID") <> "" then
		'修改QQ登陆配置
		Call doLoginQQEdit( dict("QQ_APP_ID") , dict("QQ_APP_KEY") , dict("QQ_CALLBACL_URL") )	
		end if

		if dict("WEIBO_APP_KEY") <> "" then
		'修改新浪登陆配置
		Call doLoginWeiboEdit( dict("WEIBO_APP_KEY") , dict("WEIBO_APP_SECRET") , dict("WEIBO_CALLBACK_URL") )	
		end if

		objCMS.clearCache
		if POP_MVC.req("keyword") <> "" then
			that.success(Array("保存成功","?c=manage&a=search&keyword=" & POP_MVC.req("keyword")  ))
		else
			that.success(Array("保存成功","?" & that.form("reffer") & "#Group-" & that.form("GroupID")  ))
		end if
	end sub

	'上传图片
	sub uploads
		dim filename
		POP_MVC.config("UPLOAD_ALLOW_TYPES") = "jpg;jpeg;png;gif;bmp;pcx;svg"
		filename = POP_MVC.upload("file")
		if filename <> "" then
			that.success( filename )
		else
			that.error( POP_MVC.Uploader.description )
		end if
	end sub
	
	'网站配置查询
	sub search
		dim obj,templatePath,keywords
		dim compiler,rs,where,rs2,configRS,id,value
		
		'post时		
		if that.isPost and that.form("ConfigID") <> "" then	
			Call SuperAdminPower
			id = that.form("ConfigID")
			set where = D_
			where( "ConfigID" ) = id
			where( "ConfigInput" ) = "select"
			value = POP_MVC.String.decodeHtml(POP_MVC.form("Content"))
			Call B_("self_GuestConfig").where(id).setField( "SelectOptions" , value )
			
			that.success( Array( "选项值修改成功！"  , "?Manage_Search_" & id & guestConfig.PageSuffix  & "#" & "select" ) )
		end if
		
		Call objCMS.clearCompile
		
		'如果搜索关键字不为空，则进行取值显示
		keywords = POP_MVC.req("keyword")
		if keywords <> "" then		
			set where = D_
			where("a.GroupID = b.GroupID") = null
			if not isNul( GroupID ) then
				where("b.GroupID") = Array( "IN" ,GroupID )
			end if
			set rs = B_("self_GuestConfig").from("{prefix}self_GuestConfigGroup as a,{prefix}self_GuestConfig as b").field("a.GroupID,a.GroupName,b.ConfigID,b.ConfigName,b.ConfigValue,b.ConfigTitle,b.ConfigDesc,b.SelectOptions,b.ConfigInput").where(where).order("a.GroupOrder ASC,a.GroupID ASC,b.ConfigID ASC").page("1,500").search(  keywords , "ConfigTitle,ConfigValue,GroupName" )
			
			that.d("rs") = rs		
			that.d("UserGroupRS") = B_("UserGroup").field("GroupID,GroupName").order("GroupOrder ASC").select		
		end if
		
		'显示所有下拉列表的选项
		set where = D_
		where("a.GroupID = b.GroupID") = null
		where("ConfigInput") = "select"
		set rs2 = B_("self_GuestConfig").from("{prefix}self_GuestConfigGroup as a,{prefix}self_GuestConfig as b").field("a.GroupID,a.GroupName,b.ConfigID,b.ConfigName,b.ConfigValue,b.ConfigTitle,b.ConfigDesc,b.SelectOptions,b.ConfigInput").where(where).order("a.GroupOrder ASC,a.GroupID ASC,b.ConfigID ASC").page("1,500").select
		that.d("rs2") = rs2
		

		
		'对应配置中的ConfigID
		id = that.get("id")
		'如果指定了某项配置ID，则取值准备显示				
		if isNumeric(id) and id <> "" then
			set where = D_
			where("a.GroupID = b.GroupID") = null
			where("ConfigInput") = "select"
			where("ConfigID") = id
			set configRS = B_("self_GuestConfig").from("{prefix}self_GuestConfigGroup as a,{prefix}self_GuestConfig as b").field("a.GroupID,a.GroupName,b.ConfigID,b.ConfigName,b.ConfigValue,b.ConfigTitle,b.ConfigDesc,b.SelectOptions,b.ConfigInput").where(where).order("a.GroupOrder ASC,a.GroupID ASC,b.ConfigID ASC").page("1,500").find
			
			if configRS.eof then
				that.error( Array("您查找的 ID:" & id & " 配置不存在" , "?Manage_Search" & guestConfig.PageSuffix & "#select" )  )
			end if
			
			that.d("conf") = configRS
		end if
	
		
		set obj = objCMS
		Call obj.clearCompile
		templatePath= obj.getTemplatePath( "manage/search" )		
		obj.load(templatePath)			
		
		' 使用模板引擎解析		
		set compiler = P_("TEMPLATE_COMPILER")
		compiler.content = obj.content		
		obj.content = compiler.compile
		
		obj.parseHtml
		obj.output
	end sub	
	
	'清除过程数据
	sub clearRuntime
		objCMS.clearRuntime
		that.success("过程数据清除成功!")	
	end sub
	
	'清除缓存
	sub clearCache
		objCMS.clearCache
		that.success("缓存清除成功!")	
	end sub
	
	'网站配置
	Private sub SetConfig(GroupID)
		dim obj,templatePath	
		dim compiler,rs,where
		POP_MVC.config("APP_DEBUG") = 1		
		
		set where = D_
		where("a.GroupID = b.GroupID") = null
		if not isNul( GroupID ) then
			where("b.GroupID") = Array( "IN" ,GroupID )
		end if
		set rs = B_("self_GuestConfig").from("{prefix}self_GuestConfigGroup as a,{prefix}self_GuestConfig as b").field("a.GroupID,a.GroupName,b.ConfigID,b.ConfigName,b.ConfigValue,b.ConfigTitle,b.ConfigDesc,b.SelectOptions,b.ConfigInput").where(where).order("a.GroupOrder ASC,a.GroupID ASC,b.ConfigID ASC").page("1,500").select
		
		that.d("rs") = rs
		that.d("GroupRS") = B_("self_GuestConfigGroup").where( GroupID ).order("GroupOrder ASC").page("1,500").select
		
		that.d("UserGroupRS") = B_("UserGroup").field("GroupID,GroupName").order("GroupOrder ASC").select
		
		set obj = objCMS
		Call obj.clearCompile
		templatePath= obj.getTemplatePath( "manage/config" )		
		obj.load(templatePath)	
		' 使用模板引擎解析		
		set compiler = P_("TEMPLATE_COMPILER")
		compiler.content = obj.content		
		obj.content = compiler.compile	
		obj.parseHtml
		obj.output
	end sub		
	
	'修改API/qq/config.asp文件中的配置
	Private sub doLoginQQEdit( QQ_APP_ID , QQ_APP_KEY , QQ_CALLBACL_URL ) 
		dim path,content
		path = "./API/qq/config.asp"
		
		if POP_MVC.File.isFile(path) then
			content = POP_MVC.file_get_contents( path )
			content = POP_MVC.String.reg_replace2( content, "\bQQ\_APP\_ID\s*\=\s*("".*?"")" , "$1" ,"""" & QQ_APP_ID & """"  )		
			content = POP_MVC.String.reg_replace2( content, "\bQQ_APP_KEY\s*\=\s*("".*?"")" , "$1" ,"""" & QQ_APP_KEY & """"  )
			content = POP_MVC.String.reg_replace2( content, "\bQQ_CALLBACL_URL\s*\=\s*("".*?"")" , "$1" ,"""" & QQ_CALLBACL_URL & """"  )
			call POP_MVC.file_put_contents( path,content )		
			objCMS.clearCache
		end if
	End sub
	
	'修改API/sina/config.asp文件中的配置
	Private sub doLoginWeiboEdit( WEIBO_APP_KEY , WEIBO_APP_SECRET , WEIBO_CALLBACK_URL ) 
		dim path,content
		path = "./API/sina/config.asp"
		
		if POP_MVC.File.isFile(path) then
			content = POP_MVC.file_get_contents( path )
			content = POP_MVC.String.reg_replace2( content, "\bWEIBO_API_KEY\s*\=\s*("".*?"")" , "$1" ,"""" & WEIBO_APP_KEY & """"  )
			content = POP_MVC.String.reg_replace2( content, "\bWEIBO_SEKRET_KEY\s*\=\s*("".*?"")" , "$1" ,"""" & WEIBO_APP_SECRET  & """" )
			content = POP_MVC.String.reg_replace2( content, "\bWEIBO_CALLBACK_URL\s*\=\s*("".*?"")" , "$1" ,"""" & WEIBO_CALLBACK_URL & """" )
			call POP_MVC.file_put_contents( path,content )
			objCMS.clearCache
		end if
	End sub
	
	'设置页面
	sub settings
		dim obj,templatePath,str,data
		
		'头像库
		str = B_("self_GuestConfig").field( "SelectOptions" ).where("ConfigName='"& "AvatarType" &"'").getOne()
		set data = K_("bbs--Public").option2dict(str)
		that.d("avatar") = data
		
		set obj = objCMS
		templatePath= obj.getTemplatePath( "manage/set" )			
		obj.load(templatePath)	
		obj.parseHtml	
		objCMS.output
	end sub
	
	'设置头像库
	sub editAvatarType
		dim dict,str
		set dict = POP_MVC.form2dict
		for i = 1 to dict.count/2
			if dict( "title" & i ) <> "" then
				str = str & "<option value=""" & dict( "value" & i ) & """>" & dict( "title" & i ) & "</option>" & vbcrlf
			end if
		next
	

		if str <> "" then
			Call B_("self_GuestConfig").where( that.dict( "ConfigName" , "AvatarType"  ) ).setField( "SelectOptions",str )  
			that.success( Array( "头像库设置成功！"  , "?Manage_avatar" & guestConfig.PageSuffix  & "#set" ) )
		else
			that.error("头像库不能少于一个！")
		end if		
	end sub
	
	
	'设置头像库
	sub addAvatarType
		dim dict,str,arr,value,title,content,path,cnt,imgpath
		set dict = POP_MVC.form2dict
		
		'路径名
		value = replace(dict("value")," ","")
		
		'说明
		title = replace(dict("title")," ","")
		
		'所有图片
		arr = P_("http").FetchImgUrls(dict("Content"),false)
		
		if ubound(arr) < 0 then
			that.error("未得到有效图片")
		end if
		
		'路径
		path = objCMS.getTplFolderPath() & "/res/images/" & value
		
		
		
		'不存在文件夹则创建
		if not POP_MVC.file.isFolder( path ) then
			Call POP_MVC.CreateFolder( path )
		end if
		
		
		'取得图片个数
		cnt = objCMS.getAvatarCount( value )
		
		'将图片进行移动		
		for i = 0 to ubound(arr)
			imgpath = path & "/" & ( cnt + i ) & POP_MVC.file.extname( arr(i) )
			Call POP_MVC.file.rename( arr(i) ,imgpath )
		next
		
		str = B_("self_GuestConfig").field( "SelectOptions" ).where("ConfigName='"& "AvatarType" &"'").getOne()
		
		'如果不存在还需要向数据库中添加
		if not POP_MVC.String.iExists( str, "value=""" & value & """" ) then
			str = str & "<option value=""" & value & """>" & title & "</option>" & vbcrlf
			Call B_("self_GuestConfig").where( that.dict( "ConfigName" , "AvatarType"  ) ).setField( "SelectOptions",str )  
		end if
	
		that.success( Array( "头像库添加成功！"  , "?user_avatar" & guestConfig.PageSuffix  & "#" & value ) )	
	end sub
	
	sub avatar
		dim obj,templatePath,str,data
		
		'引入summernote之前,要先引入该模块
		POP_MVC.config( "AUTO_EXTENDS_MODULE" ) = "summernote"
		
		'自动化导入summernote
		that.d("summernote") = P_("auto").summernote("#L_content")
		
		'头像库
		str = B_("self_GuestConfig").field( "SelectOptions" ).where("ConfigName='"& "AvatarType" &"'").getOne()
		set data = K_("bbs--Public").option2dict(str)
		that.d("avatar") = data
		
		set obj = objCMS
		templatePath= obj.getTemplatePath( "manage/avatar" )			
		obj.load(templatePath)	
		obj.parseHtml	
		objCMS.output
	end sub
end Class
%>