<%
Class Reply 'Extends bbs--Common
	private tableName
	sub initialize
		tableName = "self_GuestReply"
		that.d("layuicachepage") = "jie"
	end sub
	
	
	'删除回帖
	'一次性彻底删除
	Sub Remove
		dim id,rs,authInfo
		id = that.req("id")
		
		'来路不对
		if not that.isSelfOrigin then
			that.error("非法操作")
		end if			
		
		'不是有效的ID
		if not that.isId( id ) then
			that.error( "非法操作" )
		end if
		
		'根据ID取记录
		set rs = B_(tableName).where(id).find
		
		if rs.eof then
			that.error("回帖不存在")
		end if	

		if rs("UserID") - S_("adminId") <> 0 AND S_("IsAdmin") <> 1 then
			that.error("您无权删除该回帖")
		end if
		
		authInfo = K_("bbs--Public").AuthCompare( rs("UserID") , "的回帖进行删除操作！" )
		
		if authInfo <> "" then
			that.error( authInfo )
		end if	
		
		'回帖个数减1
		Call B_("self_GuestTopic").where( rs("TopicID") ).setDec("ReplyCount")
		
		that.u(rs)
		
		B_("self_GuestReply").where( id ).remove
		objCMS.clearCache
		that.success("回帖删除成功")
	End Sub	
	
	
	'采纳回帖
	Sub Accept
		dim id,rs,threadRS
		id = that.req("id")
		
		'来路不对
		if not that.isSelfOrigin then
			that.error("非法操作")
		end if			
		
		'不是有效的ID
		if not that.isId( id ) then
			that.error( "非法操作" )
		end if
		
		'根据ID取记录
		set rs = B_(tableName).where(id).find
		
		if rs.eof then
			that.error("回帖不存在")
		end if	

		if rs("UserID") = S_("adminId") then
			that.error("您不能采纳自已的回帖！")
		end if
		
		set threadRS = B_("self_GuestTopic").where( rs("TopicID") ).find
		
		if threadRS("UserID") - S_("adminId") <> 0 and S_("IsAdmin") <> 1 then
			that.error( "您无权操作！" )
		end if

		'先将所有的回帖IsAdopted设为0
		Call B_(tableName).where( that.dict( "TopicID" , CStr(rs("TopicID")) ) ).setField( "IsAdopted" , 0 )
		'再将指定ID的回帖IsAdopted设为1
		Call B_(tableName).where(id).setField( "IsAdopted" , 1)
		'设为已结帖子
		Call B_("self_GuestTopic").where( rs("TopicID") ).setField( "IsSolved" , 1 )
		Call B_("self_GuestTopic").where( rs("TopicID") ).setField( "IsClosed" , 1 )

		'将悬赏分添加到Reward字段中
		Call B_(tableName).where(id).setField( "Reward" , threadRS("AnswerReward") )
		'将悬赏分加到相应用户积分中
		Call B_("User").where( threadRS("UserID") ).setInc( Array( "Experience" , threadRS("AnswerReward") ) )
		objCMS.clearCache
		that.success("采纳成功")
	End Sub		
	

	'修改页面
	sub edit
		'判断是否允许普通用户回帖

		if guestConfig.ReplyEditAllow = 0 AND S_("IsAdmin")<>1 then
			K_("bbs--Public").showError( guestConfig.ReplyForbidTip )
		end if		
	
		dim id,rs,authInfo
		id = that.get("id")
		set rs = B_(tableName).where(id).find
		
		'判断是否有编辑帖子的权限
		if rs("UserID") <> S_("adminId") and S_("IsAdmin") <> 1 then
			that.error("您没有权限编辑该回帖")
		end if
		
		authInfo = K_("bbs--Public").AuthCompare( rs("UserID") , "的回帖进行编辑操作！" )
		
		if authInfo <> "" then
			that.error( authInfo )
		end if	
		
		that.d("reply") = rs
		
		POP_MVC.config( "AUTO_EXTENDS_MODULE" ) = "summernote"
		that.d("summernote") = P_("auto").summernote("#L_content")
		dim obj,templatePath
		set obj = objCMS
		templatePath= obj.getTemplatePath( "jie/reply-edit" )
		obj.load(templatePath)	
		obj.parseHtml
		obj.output
	end sub
	
	'快速回复操作
	sub quickAdd
		dim id,TopicID
		
		TopicID = that.req("TopicID")
		
		Call addBefore( TopicID )

		if not M_( "bbs--Reply" ).db.create(1) then
			that.error( M_( "bbs--Reply" ).db.error )
		end if		
		
		id = M_( "bbs--Reply" ).db.add
		
		Call addAfter(id , TopicID , that.form("MessageToUser") , that.form("MessageTitle") , that.form("page") )
	end sub	
	
	'回复操作
	sub doAdd
		dim id,dict,TopicID
		
		TopicID = that.form("TopicID")
		
		Call addBefore( TopicID )
		
		if not M_( "bbs--Reply" ).db.create(1) then
			that.error( M_( "bbs--Reply" ).db.error )
		end if
		
		
		id = M_( "bbs--Reply" ).db.add
		Call addAfter(id , TopicID , that.form("MessageToUser") , that.form("MessageTitle") , that.form("page") )
	end sub	
	
	private sub addBefore( TopicID )
		dim errStr,topicRS,where,where2
		
		'禁止回帖
		if B_("user").where(S_("adminId")).field("ReplyStatus").getOne = 0 then
			that.error( "您已被禁止回帖！" )
		end if
		
		set where = D_		
		
		where("a.TopicID") = TopicID
		where("a.UserID = c.UserID ") = null
		

		set topicRS= B_("self_GuestConfig").onlysql(0).from(C_("THREAD_TABLE")).field(C_("THREAD_FIELD")).where( where ).find
		
		'''''回复内容'''''
		if guestConfig.ReplyAddAllow = 0 then
			'是否允许回帖
			errStr = guestConfig.ReplyAddAllowTip
		elseif topicRS("IsNoComment") = 1 then
			'帖子禁回提示
			errStr = guestConfig.ReplyNoCommentTip
		elseif datediff( "d" , topicRS("AddTime") , now ) - guestConfig.ReplyTimeLimit > 0 then
			'超回帖时间提示
			errStr = guestConfig.ReplyTimeLimitTip
		elseif topicRS("ReplyCount") - guestConfig.ReplyCountLimit >= 0 and S_("IsAdmin") - 1 <> 0 then
			'最多回帖提示
			errStr = guestConfig.ReplyCountLimitTip
		elseif guestConfig.ReplyDayLimit <> 0 and S_("IsAdmin") - 1 <> 0 then
			set where2 = D_
			where2("UserID") = S_("adminId")
			where2("AddTime") = array( "daydiff" , 1 )
			'回帖达到上限后的提示
			if B_("self_GuestReply").where( where2 ).count - guestConfig.ReplyDayLimit >= 0  then
				errStr = guestConfig.ReplyDayLimitTip
			elseif B_("user").where(S_("adminId")).field("ReplyStatus").getOne = 0 then
				'用户禁回帖提示
				errStr = guestConfig.ReplyForbidTip
			end if
		end if
		
		'禁止回帖
		if errStr <> "" then
			that.error( errStr )
		end if
	end sub
	
	private sub addAfter(id , TopicID , MessageToUser , MessageTitle , page )
		if id > 0 then		
			'回帖个数加１
			Call B_("self_GuestTopic").where( TopicID ).setInc("ReplyCount")
			
			'回帖时加上奖励积分
			if not is_numeric( guestConfig.ReplyAddReward ) then
				guestConfig.ReplyAddReward = 0				
			end if
			
			if guestConfig.ReplyAddReward > 0 then
				Call B_("User").where( S_("adminId") ).setInc( Array("Experience" , guestConfig.ReplyAddReward)  )
			end if
			
			'向发帖者发送一条回帖提示消息
			Call K_("bbs--Public").SendMessage4reply( TopicID , id , MessageToUser , MessageTitle,  page   )
			
			'因回复中引用了他人，发送消息提示"提到了您"
			dim content,arr
			content = request.form("Content")
			arr = POP_MVC.String.reg_array( content, "<a[^>]+href\s*=\s*(""|'|)[^>]+bbs\W{2}u_(\d+)\1[^>]*\>" , 2,"gim" )			
			for i = 0 to ubound(arr)
				if CStr( arr(i) ) <> CStr( S_("adminId") ) AND CStr( MessageToUser ) <> CStr( arr(i) ) then
					Call K_("bbs--Public").SendMessage4cite( TopicID , id , arr(i) , MessageTitle,  page   )
				end if
			next

			if guestConfig.ReplyReminded = 1 then
				K_("bbs--mail").AddReply( id )
			end if
			objCMS.clearCache
			that.success( Array("回答成功","?Last_" & TopicID & "_" & id & guestConfig.pageSuffix & "#" & id ) )
		else
			that.error( "添加失败，请重新提交" )
		end if	
	end sub
	
	'修改操作
	sub doEdit
		if not M_( "bbs--Reply" ).db.create(2) then
			that.error( M_( "bbs--Reply" ).db.error )
		end if
		
		if  M_( "bbs--Reply" ).db.save then		
			if guestConfig.ReplyReminded = 1 then
				K_("bbs--mail").EditReply( that.form("ReplyID") )
			end if		
			objCMS.clearCache
			that.success( Array("修改成功" , that.form("refer") ) )
		else
			'B_("self_GuestConfig").Rollback
			that.error( "修改失败，请重新提交" )
		end if
	end sub
	
	'对上传图片提前进行登陆判断
	sub before__upload4summernote
		dim dict
		set dict = D_
		if S_("adminId") = "" then			
			dict("status") = that.ajaxErrorStatus
			dict("msg") = "请登陆后发帖"
			dict("url") = false
			that.ajaxData(dict)
		else
			POP_MVC.config("UPLOAD_ALLOW_TYPES") = "jpg;jpeg;png;gif;bmp;pcx;svg"
		end if
	end sub
	
	Private sub sendMessage(  )
	end sub
end Class
%>