<%
Class System 'Extends bbs--Common
	private tableName,accPath,sqlitePath
	sub initialize
		if S_("IsAdmin") <> 1 then
			that.error("您无权查看该页面")
		end if
		tableName = "User"
		that.d("layuicachepage") = "system"
		accPath = POP_MVC.config("CORE_NAME") & "/" & POP_MVC.config("DATA_NAME") & "/#aspbbs#.mdb"
		sqlitePath = POP_MVC.config("CORE_NAME") & "/" & POP_MVC.config("DATA_NAME") & "/#aspbbs#.db"
	end sub
	
	'冗余文件
	private sub redundancy
		dim str,time1,time2,filepath	
		filepath = POP_MVC.appPath & "/runtime/redundancy/table.txt"
		'如果已经保存了检测，且未再上传，从文件中显示
		if POP_MVC.file.isfile(filepath) then
			time1 = POP_MVC.file.mtime( filepath )
			time2 = POP_MVC.file.mtime( POP_MVC.config("CMS_UPLOAD_PATH") )
			if  DateDiff("s", time2, time1) > 0 then
				that.d("loopstr") = K_("bbs--FileTool").file_get_redundancy
			end if
		end if
	end sub
	
	'冗余文件
	private sub emptyFolder
		dim str,time1,time2,filepath	
		filepath = POP_MVC.appPath & "/runtime/emptyFolder/table.txt"
		'如果已经保存了检测，且未再上传，从文件中显示
		if POP_MVC.file.isfile(filepath) then
			time1 = POP_MVC.file.mtime( filepath )
			time2 = POP_MVC.file.mtime( POP_MVC.config("CMS_UPLOAD_PATH") )
			if  DateDiff("s", time2, time1) > 0 then
				that.d("emptystr") = K_("bbs--FileTool").file_get_empty
			end if
		end if
	end sub
	
	'数据库初始化
	sub InitDataBase
		on error resume next
		Server.ScriptTimeOut=99999
		

		
		'if not that.isSelfOrigin then
		'	that.error("非法操作")
		'end if	
		
		'备份数据库
		'K_("bbs--System").BackupDatabase("")
		
		'初始化数据库
		K_("bbs--System").InitDatabase("")

		that.success( Array("初始化成功" , -1 ))
	end sub
	
	'基本设置页面
	sub settings
		dim obj,templatePath,mailType
		set obj = objCMS
		Call redundancy
		Call emptyFolder
		that.d("backupFolder") = POP_MVC.config("CORE_NAME") & "/" & POP_MVC.config("DATA_NAME") & "/backup"
		
		if not POP_MVC.file.isFile(accPath) then
			that.d("accInfo") = "access数据库不存在"
		else
			that.d("accInfo") = byte2size( POP_MVC.file.filesize( accPath ) )
		end if
		
		if not POP_MVC.file.isFile(sqlitePath) then
			that.d("sqliteInfo") = "sqlite3数据库不存在"
		else
			that.d("sqliteInfo") = byte2size( POP_MVC.file.filesize( sqlitePath ) )
		end if
		
		that.d("mailType") = K_("plugin--public").getMailType( guestConfig.mail_type )
		templatePath= obj.getTemplatePath( "system/set" )		
		obj.load(templatePath)	
		obj.parseHtml
		objCMS.output
	end sub	
	
	'压缩access数据库
	sub CompressAccess
		if not POP_MVC.file.isFile( accPath ) then
			that.success( array("系统指定的access数据库不存在") )
		end if
		Call POP_MVC.file.AccessCompress( accPath )	
		that.success( array("压缩成功") )
	end sub
	
	'文件型数据库备份
	sub DbBackup
		dim dbDir,dbPath,dbName
		dbDir = POP_MVC.config("CORE_NAME") & "/" & POP_MVC.config("DATA_NAME") & "/"
		dbType = POP_MVC.req("type")
		
		select case dbType
			case "access"
				dbName = "#aspbbs#.mdb"
			case "sqlite3"
				dbName = "#aspbbs#.db"
		end select
		
		dbPath = dbDir & dbName
		if not POP_MVC.file.isFile( dbPath ) then
			that.error( array("系统指定的" & dbType & "数据库" & dbName & "不存在，不能完成备份！") )
		end if
		K_("bbs--System").BackupDatabase( dbPath )		
		that.success( Array( "备份成功" ) )
	end sub
	
	'数据库转换
	sub db2db
		dim srcType,dstType,srcPath,dstPath,errStr
		dim dbDir
		dbDir = POP_MVC.config("CORE_NAME") & "/" & POP_MVC.config("DATA_NAME") & "/"
		srcType = POP_MVC.req("scrType")
		dstType = POP_MVC.req("dstType")
		
		select case srcType
			case "access"
				srcPath = dbDir & "#aspbbs#.mdb"
			case "sqlite3"
				srcPath = dbDir & "#aspbbs#.db"
			case "mysql"
				srcPath = C_("DB_NAME")
		end select
		
		errStr = P_("db").testConnect( Array( srcType , srcPath ) )
		
		'先测试数据库是否能够连接
		if errStr <> "" then
			that.error( errStr )
		end if
		
		select case dstType
			case "access"
				dstPath = dbDir & "#aspbbs#.mdb"
			case "sqlite3"
				dstPath = dbDir & "#aspbbs#.db"
			case "mysql"
				dstPath = C_("DB_NAME")
		end select
		
		errStr = P_("db").testConnect( Array( dstType , dstPath ) )
		
		'测试数据库是否能够连接
		if errStr <> "" then
			that.error( errStr )
		end if

		
		select case dstType
			case "access"
				Call B_( Array("user" , srcType, srcPath ) ).toAccWithData( dstPath )
			case "sqlite3"
				Call B_( Array("user" , srcType, srcPath ) ).toSqliteWithData( dstPath )
				Call sqliteFormatDate
			case "mysql"
				Call B_( Array("user" , srcType, srcPath ) ).toMysqlWithData( dstPath )
		end select
		that.success( Array(srcType & " 转换到 " & dstType & " 完成!"  ))
	end sub
	
	private sub sqliteFormatDate()
		dim rs,dict,dbPath
		
		set dict = D_
		dbPath = POP_MVC.config("CORE_NAME") & "/" & POP_MVC.config("DATA_NAME") & "/#aspbbs#.db"
		
		set rs = B_( Array("self_GuestDigg" , "sqlite3" , dbPath) ).field("UserID,AddTime,EditTime,SignTime").select		
		B_( Array("self_GuestDigg" , "sqlite3" , dbPath) ).begin
		do while not rs.eof
			dict("AddTime") = POP_MVC.FormatDate(rs("AddTime") , "YYYY-MM-DD HH:II:SS" )
			dict("EditTime") = POP_MVC.FormatDate(rs("EditTime") , "YYYY-MM-DD HH:II:SS" )
			dict("SignTime") = POP_MVC.FormatDate(rs("SignTime") , "YYYY-MM-DD HH:II:SS" )
			Call B_( Array("self_GuestDigg" , "sqlite3" , dbPath) ).where( rs("UserID") ).setField( dict,null )
			rs.movenext
		loop
		B_( Array("self_GuestDigg" , "sqlite3" , dbPath) ).commit
		that.u(rs)
		dict.removeAll
		
		set rs = B_( Array("self_GuestDonate" , "sqlite3" , dbPath) ).field("DonateID,DealTime,AddTime").select
		B_( Array("self_GuestDonate" , "sqlite3" , dbPath) ).begin
		do while not rs.eof
			dict("DealTime") = POP_MVC.FormatDate(rs("DealTime") , "YYYY-MM-DD HH:II:SS" )
			dict("AddTime") = POP_MVC.FormatDate(rs("AddTime") , "YYYY-MM-DD HH:II:SS" )
			Call B_( Array("self_GuestDonate" , "sqlite3" , dbPath) ).where( rs("DonateID") ).setField( dict,null )
			rs.movenext
		loop
		B_( Array("self_GuestDonate" , "sqlite3" , dbPath) ).commit
		that.u(rs)
		dict.removeAll
		
		set rs = B_( Array("self_GuestMessage" , "sqlite3" , dbPath) ).field("MessageID,AddTime").select
		B_( Array("self_GuestMessage" , "sqlite3" , dbPath) ).begin		
		do while not rs.eof
			Call B_( Array("self_GuestMessage" , "sqlite3" , dbPath) ).where( rs("MessageID") ).setField( "AddTime",POP_MVC.FormatDate(rs("AddTime") , "YYYY-MM-DD HH:II:SS" ) )
			rs.movenext
		loop
		B_( Array("self_GuestMessage" , "sqlite3" , dbPath) ).commit	
		that.u(rs)
		
		set rs = B_( Array("self_GuestReply" , "sqlite3" , dbPath) ).field("ReplyID,AddTime,EditTime").select	
		B_( Array("self_GuestReply" , "sqlite3" , dbPath) ).begin	
		do while not rs.eof
			dict("AddTime") = POP_MVC.FormatDate(rs("AddTime") , "YYYY-MM-DD HH:II:SS" )
			dict("EditTime") = POP_MVC.FormatDate(rs("EditTime") , "YYYY-MM-DD HH:II:SS" )
			Call B_( Array("self_GuestReply" , "sqlite3" , dbPath) ).where( rs("ReplyID") ).setField( dict,null )
			rs.movenext
		loop
		B_( Array("self_GuestReply" , "sqlite3" , dbPath) ).commit	
		that.u(rs)
		dict.removeAll		
		
		set rs = B_( Array("self_GuestTopic" , "sqlite3" , dbPath) ).field("TopicID,AddTime,EditTime").select
		B_( Array("self_GuestTopic" , "sqlite3" , dbPath) ).begin	
		do while not rs.eof
			dict("AddTime") = POP_MVC.FormatDate(rs("AddTime") , "YYYY-MM-DD HH:II:SS" )
			dict("EditTime") = POP_MVC.FormatDate(rs("EditTime") , "YYYY-MM-DD HH:II:SS" )
			Call B_( Array("self_GuestTopic" , "sqlite3" , dbPath) ).where( rs("TopicID") ).setField( dict,null )
			rs.movenext
		loop
		B_( Array("self_GuestTopic" , "sqlite3" , dbPath) ).commit
		that.u(rs)
		dict.removeAll	
		
		set rs = B_( Array("User" , "sqlite3" , dbPath) ).field("UserID,RegTime,LastLoginTime,Birthday,SendForgetMailTime,SendActivateMailTime").select		
		B_( Array("User" , "sqlite3" , dbPath) ).begin	
		do while not rs.eof
			dict("RegTime") = POP_MVC.FormatDate(rs("RegTime") , "YYYY-MM-DD HH:II:SS" )
			dict("LastLoginTime") = POP_MVC.FormatDate(rs("LastLoginTime") , "YYYY-MM-DD HH:II:SS" )
			dict("Birthday") = POP_MVC.FormatDate(rs("Birthday") , "YYYY-MM-DD HH:II:SS" )
			dict("SendForgetMailTime") = POP_MVC.FormatDate(rs("SendForgetMailTime") , "YYYY-MM-DD HH:II:SS" )
			dict("SendActivateMailTime") = POP_MVC.FormatDate(rs("SendActivateMailTime") , "YYYY-MM-DD HH:II:SS" )
			Call B_( Array("User" , "sqlite3" , dbPath) ).where( rs("UserID") ).setField( dict,null )
			rs.movenext
		loop
		B_( Array("User" , "sqlite3" , dbPath) ).commit	
		that.u(rs)
		dict.removeAll				
	End sub
	
	'切换数据库
	sub switchDb
		dim dstType,srcType,errStr,dbPath
		dstType = POP_MVC.req("type")
		srcType = POP_MVC.config("DB_TYPE")
		
		if dstType = srcType then
			that.success( "不用切换，当前数据库已经是 " & srcType )
		end if
		
		if dstType = "access" then
			dbPath = POP_MVC.config("CORE_NAME") & "/" & POP_MVC.config("DATA_NAME") & "/#aspbbs#.mdb"
			if not POP_MVC.file.isFile(dbPath) then
				errStr = "数据库文件 " & dbPath & " 不存在！"
			end if
		elseif dstType = "sqlite3" then
			dbPath = POP_MVC.config("CORE_NAME") & "/" & POP_MVC.config("DATA_NAME") & "/#aspbbs#.db"
			if not POP_MVC.file.isFile(dbPath) then
				errStr = "数据库文件 " & dbPath & " 不存在！"
			end if
		end if
		
		if errStr <> "" then
			that.error( errStr )
		end if		

		errStr = P_("db").testConnect( Array(dstType,dbPath) )
		
		'先测试数据库是否能够连接
		if errStr <> "" then
			that.error( errStr )
		end if
		
		Call K_("bbs--system").ModifyConfig("./#config.asp" , "DB_TYPE" , dstType )
		that.success( Array( "数据库已经切换到了" & dstType ))
	end sub
	
	
	'导入旧版数据库
	sub importDataBase
		dim dbType,srcdb,errStr
		dbType = POP_MVC.req("type")
		srcdb = POP_MVC.req("OldDb")

		errStr = P_("db").testConnect( Array( dbType , srcdb ) )
		
		'先测试数据库是否能够连接
		if errStr <> "" then
			that.error( errStr )
		end if
		
		if dbType = "sqlite3" then
			if B_( Array( "user" , dbType , srcDb ) ).count = 0 then
				that.error( dbType & "数据库发生错误！" )
			end if
		end if
		
		Call importConfigs( dbType,srcdb )
		
		Call importData( dbType,srcdb )
		
		if POP_MVC.config("DB_TYPE") = "sqlite3" then
			Call sqliteFormatDate
		end if
		that.success( Array("导入成功"))	
	end sub
	
	'操作，删除数据库
	sub RemoveDataBase
		dim ret,arr,i,files
		arr = split( POP_MVC.req("OldDb") , "," )
		
		for i = 0 to ubound(arr)
			ret = POP_MVC.file.removeFromDir( POP_MVC.config("CORE_NAME") & "/" & POP_MVC.config("DATA_NAME") , trim( arr(i) ) )
			POP_MVC.Arr.push files, POP_MVC.file.basename( arr(i) )
			if not ret then
				that.error( ret & "删除失败，中止操作" )
			end if		
		next
		that.success( Array("删除成功" , "" ))
	end sub
	
	'修改核心文件夹名 核心文件夹名称(默认:core)最好是别人猜不到的。
	sub EditCorePath
		dim newPath,errStr
		newPath = POP_MVC.req("folder")
		if newPath = "" then
			newPath = "#" & POP_MVC.String.uniqid()
		end if
		if LCase( POP_MVC.trim(POP_MVC.file.dir(POP_MVC.appPath),"/") ) = LCase(newPath) then
			that.error("与当前名称相同！")
		end if
		Server.ScriptTimeOut=5000
		errStr = K_("bbs--system").ModifyAdminFolderName(newPath , 1 ) 'that.req("_IsVituralHost")
		if errStr <> "" then
			that.error( array( errStr , "" , 5 ) )
		else
			that.success("修改成功")
		end if	
	end sub
	
	'修改模板文件夹html名 模板文件夹html改名，可以保护模板文件不被别人下载。
	sub EditHtmlPath
		dim configValue
		configValue = POP_MVC.req("configValue")
		if LCase(config.htmlFilePath) = LCase(configValue) then
			that.error("与当前名称相同！")
		end if
		if POP_MVC.file.rename("./templates/" & guestConfig.DefaultTemplate & "/" & config.htmlFilePath , "./templates/" & guestConfig.DefaultTemplate & "/" & configValue ) then
			Call K_("bbs--system").ModifyConfig("configs" , "HtmlFilePath" , configValue )
			that.success("修改成功")
		else
			that.error("修改失败")
		end if		
	end sub
	
	'导入配置
	Private sub importConfigs( dbType,srcdb )
		on error resume next
		dim dict
		
		set dict = B_( Array("self_GuestConfig",dbType , srcdb ) ).field("ConfigName,ConfigValue").getKeyValue()
		Call K_("bbs--update").ModifyConfig( "self_GuestConfig" , dict , "" , "" )
		'that.success( Array("导入成功" , "?System" ))		
	end sub
	
	'操作 导入数据
	Private sub importData( dbType,srcdb )
		Server.ScriptTimeOut=99999
		dim i,toTables
		
		'目前支持数据迁移的表，除这些之外还有 Language content adv(slide)
		toTables = Array("self_GuestDigg" ,"self_GuestDonate" , "self_GuestMessage" , "self_GuestReply" , "self_GuestTopic" , "User" , "UserGroup")
		
		for i = 0 to ubound( toTables )
			B_( Array("self_GuestConfigGroup" , POP_MVC.config("DB_TYPE") , POP_MVC.config("DB_PATH") ) ).truncate( toTables(i) )
			'var_Export "<div style='margin-left:30%;'>表" & toTables(i) & "清空完成" & "</div>"	
			'Response.flush
			

			Call importTable( toTables(i) , dbType , srcDb )
			'var_Export "<div style='margin-left:30%;'>表" & toTables(i) & "导入成功" & "</div>"	
			'Response.flush
		next
		'that.success( "导入成功" )
	end sub
	
	'根据表名导入数据表
	private sub importTable( table_name , dbType , srcDb )		
		dim dstDb
		if POP_MVC.config("DB_TYPE") = "mysql" then
			dstDb = POP_MVC.config( "DB_NAME" )
		else
			dstDb = POP_MVC.config( "DB_PATH" )
		end if
		Call K_("bbs--update").importTable( table_name , POP_MVC.config( "DB_PREFIX" ) , dbType , srcdb ,POP_MVC.config("DB_PREFIX") , POP_MVC.config("DB_TYPE") , dstDb   )
	End Sub
end Class
%>