<%
'##########################################################
' 公农历互转类ASP版 V2.1
' 1.互转年限从1901~2100。
' 2.附带采用该类制作的公历节日和农历节日混合的节日倒计时程序

' Class OT_NongLiGongLi 用于农历与公历间的相互转换
' 本类可处理1900-2100年(农历)之间的公农历转换
' 本类不输出错误信息，如输出结果为1800-1-1则意味发生错误。

' 作者：网钛工作室
' 日期：2010-09-23
' 网址：http://www.oneti.cn/
' 邮箱：877873666@qq.com
' 版权：可自由传播，也可修改后应用到自己程序里，但请保留该版权及注释信息

' 应用示例：
'  Dim nongGong
'  Set nongGong = New OT_NongLiGongLi

' 公历转农历(查询日期范围1901-2-19至2100-12-31,格式yyyy-mm-dd，showMode显示模式，1.效果:农历2000年(闰)四月初六  2.效果:农历2000年(闰)4月6日  其他值.效果:2000-4-6 (闰))
'  Response.Write nongGong.GongToNong("1984-12-10",showMode)

' 农历转公历（查询日期范围1901-1-1至2100-12-29,格式yyyy-mm-dd，Ntype为"闰"或"1"，表示查询农历的月份是闰月；Ntype为""或其他值，表示不是闰月）
'  Response.Write nongGong.NongToGong("1984-10-18",Ntype)
'##########################################################

'Class OT_NongLiGongLi
Class POPASP_NONGLI

	Dim GongLi(12),NongLiStart,NongLi(200)


	Sub Class_Initialize()
		'定义公历月份天数
		GongLi(1)	= 31
		GongLi(2)	= 28
		GongLi(3)	= 31
		GongLi(4)	= 30
		GongLi(5)	= 31
		GongLi(6)	= 30
		GongLi(7)	= 31
		GongLi(8)	= 31
		GongLi(9)	= 30
		GongLi(10)	= 31
		GongLi(11)	= 30
		GongLi(12)	= 31



		'定义农历数据
		NongLiStart=1900	'农历从1900年开始
		'差：该年的农历正月初一到该年公历1月1日的天数；1~12：农历月份天数；闰：如有闰月，记录该月平月天数
		'              差  1  2  3  4  5  6  7  8  9 10 11 12 闰
		NongLi(0)	= ""
		NongLi(1)	= "49,0,14AE"
		NongLi(2)	= "38,0,1A57"
		NongLi(3)	= "28,5,2A9A"
		NongLi(4)	= "46,0,1D26"
		NongLi(5)	= "34,0,1D95"
		NongLi(6)	= "24,4,2EAA"
		NongLi(7)	= "43,0,156A"
		NongLi(8)	= "32,0,19AD"
		NongLi(9)	= "21,2,22BB"
		NongLi(10)	= "40,0,14AE"
		NongLi(11)	= "29,6,3437"
		NongLi(12)	= "48,0,1A4D"
		NongLi(13)	= "36,0,1D25"
		NongLi(14)	= "25,5,3B4A"
		NongLi(15)	= "44,0,1B54"
		NongLi(16)	= "33,0,1D6A"
		NongLi(17)	= "22,2,35B4"
		NongLi(18)	= "41,0,195B"
		NongLi(19)	= "31,7,296E"
		NongLi(20)	= "50,0,1497"
		NongLi(21)	= "38,0,1A4B"
		NongLi(22)	= "27,5,3696"
		NongLi(23)	= "46,0,16A5"
		NongLi(24)	= "35,0,16D4"
		NongLi(25)	= "23,4,376A"
		NongLi(26)	= "43,0,12B6"
		NongLi(27)	= "32,0,1957"
		NongLi(28)	= "22,2,225F"
		NongLi(29)	= "40,0,1497"
		NongLi(30)	= "29,6,2C2D"
		NongLi(31)	= "47,0,1D4A"
		NongLi(32)	= "36,0,1EA5"
		NongLi(33)	= "25,5,2D53"
		NongLi(34)	= "44,0,15AD"
		NongLi(35)	= "34,0,12B6"
		NongLi(36)	= "23,3,34DC"
		NongLi(37)	= "41,0,192E"
		NongLi(38)	= "30,7,395A"
		NongLi(39)	= "49,0,1C95"
		NongLi(40)	= "38,0,1D4A"
		NongLi(41)	= "26,6,3B94"
		NongLi(42)	= "45,0,1B55"
		NongLi(43)	= "35,0,156A"
		NongLi(44)	= "24,4,36B6"
		NongLi(45)	= "43,0,125D"
		NongLi(46)	= "32,0,192D"
		NongLi(47)	= "21,2,3257"
		NongLi(48)	= "40,0,1A95"
		NongLi(49)	= "28,7,36AA"
		NongLi(50)	= "47,0,16CA"
		NongLi(51)	= "36,0,1B55"
		NongLi(52)	= "26,5,2B6A"
		NongLi(53)	= "44,0,14DA"
		NongLi(54)	= "33,0,1A5B"
		NongLi(55)	= "23,3,2CAE"
		NongLi(56)	= "42,0,152B"
		NongLi(57)	= "30,8,3515"
		NongLi(58)	= "48,0,1E95"
		NongLi(59)	= "38,0,16AA"
		NongLi(60)	= "27,6,3555"
		NongLi(61)	= "45,0,1AB5"
		NongLi(62)	= "35,0,14B6"
		NongLi(63)	= "24,4,355C"
		NongLi(64)	= "43,0,1A57"
		NongLi(65)	= "32,0,1526"
		NongLi(66)	= "20,3,3A4D"
		NongLi(67)	= "39,0,1D95"
		NongLi(68)	= "29,7,2B2B"
		NongLi(69)	= "47,0,156A"
		NongLi(70)	= "36,0,196D"
		NongLi(71)	= "26,5,28BB"
		NongLi(72)	= "45,0,14AD"
		NongLi(73)	= "33,0,1A4D"
		NongLi(74)	= "22,4,389B"
		NongLi(75)	= "41,0,1D25"
		NongLi(76)	= "30,8,3A8B"
		NongLi(77)	= "48,0,1B54"
		NongLi(78)	= "37,0,1B6A"
		NongLi(79)	= "27,6,32B5"
		NongLi(80)	= "46,0,195B"
		NongLi(81)	= "35,0,149B"
		NongLi(82)	= "24,4,352E"
		NongLi(83)	= "43,0,1A4B"
		NongLi(84)	= "32,10,3647"
		NongLi(85)	= "50,0,16A5"
		NongLi(86)	= "39,0,16D4"
		NongLi(87)	= "28,6,3569"
		NongLi(88)	= "47,0,1AB6"
		NongLi(89)	= "36,0,1957"
		NongLi(90)	= "26,5,285F"
		NongLi(91)	= "45,0,1497"
		NongLi(92)	= "34,0,164B"
		NongLi(93)	= "22,3,2A95"
		NongLi(94)	= "40,0,1EA5"
		NongLi(95)	= "30,8,2D4B"
		NongLi(96)	= "49,0,15AC"
		NongLi(97)	= "37,0,1AB6"
		NongLi(98)	= "27,5,32DA"
		NongLi(99)	= "46,0,192E"
		NongLi(100)	= "35,0,1C96"
		NongLi(101)	= "23,4,392B"
		NongLi(102)	= "42,0,1D4A"
		NongLi(103)	= "31,0,1DA5"
		NongLi(104)	= "21,2,26AB"
		NongLi(105)	= "39,0,156A"
		NongLi(106)	= "28,7,3537"
		NongLi(107)	= "48,0,125D"
		NongLi(108)	= "37,0,192D"
		NongLi(109)	= "25,5,3857"
		NongLi(110)	= "44,0,1A95"
		NongLi(111)	= "33,0,1B4A"
		NongLi(112)	= "22,4,3555"
		NongLi(113)	= "40,0,1AD5"
		NongLi(114)	= "30,9,2AAB"
		NongLi(115)	= "49,0,14BA"
		NongLi(116)	= "38,0,1A5B"
		NongLi(117)	= "27,6,2AAE"
		NongLi(118)	= "46,0,152B"
		NongLi(119)	= "35,0,1A93"
		NongLi(120)	= "24,4,2D2B"
		NongLi(121)	= "42,0,16AA"
		NongLi(122)	= "31,0,1AD5"
		NongLi(123)	= "21,2,236B"
		NongLi(124)	= "40,0,14B6"
		NongLi(125)	= "28,6,345D"
		NongLi(126)	= "47,0,1A4E"
		NongLi(127)	= "36,0,1D26"
		NongLi(128)	= "25,5,3C4D"
		NongLi(129)	= "43,0,1D53"
		NongLi(130)	= "33,0,15AA"
		NongLi(131)	= "22,3,2AD5"
		NongLi(132)	= "41,0,196D"
		NongLi(133)	= "30,11,295B"
		NongLi(134)	= "49,0,14AD"
		NongLi(135)	= "38,0,1A4D"
		NongLi(136)	= "27,6,3A96"
		NongLi(137)	= "45,0,1D25"
		NongLi(138)	= "34,0,1D52"
		NongLi(139)	= "23,5,3AA9"
		NongLi(140)	= "42,0,1B5A"
		NongLi(141)	= "31,0,156D"
		NongLi(142)	= "21,2,22B7"
		NongLi(143)	= "40,0,149B"
		NongLi(144)	= "29,7,34AE"
		NongLi(145)	= "47,0,1A4B"
		NongLi(146)	= "36,0,1AA5"
		NongLi(147)	= "25,5,374A"
		NongLi(148)	= "44,0,16D2"
		NongLi(149)	= "32,0,1ADA"
		NongLi(150)	= "22,3,2D6C"
		NongLi(151)	= "41,0,1937"
		NongLi(152)	= "31,8,291F"
		NongLi(153)	= "49,0,1497"
		NongLi(154)	= "38,0,164B"
		NongLi(155)	= "27,6,2D94"
		NongLi(156)	= "45,0,1EA5"
		NongLi(157)	= "34,0,16AA"
		NongLi(158)	= "23,4,36D8"
		NongLi(159)	= "42,0,1AAE"
		NongLi(160)	= "32,0,192E"
		NongLi(161)	= "20,3,3A5C"
		NongLi(162)	= "39,0,1C96"
		NongLi(163)	= "28,7,3AAA"
		NongLi(164)	= "47,0,1D4A"
		NongLi(165)	= "35,0,1DA5"
		NongLi(166)	= "25,5,2AAB"
		NongLi(167)	= "44,0,156A"
		NongLi(168)	= "33,0,1A6D"
		NongLi(169)	= "22,4,28BB"
		NongLi(170)	= "41,0,152D"
		NongLi(171)	= "30,8,3517"
		NongLi(172)	= "49,0,1A95"
		NongLi(173)	= "37,0,1B4A"
		NongLi(174)	= "26,6,3655"
		NongLi(175)	= "45,0,1AD5"
		NongLi(176)	= "35,0,155A"
		NongLi(177)	= "23,4,3574"
		NongLi(178)	= "42,0,1A5B"
		NongLi(179)	= "32,0,152B"
		NongLi(180)	= "21,3,324F"
		NongLi(181)	= "39,0,1693"
		NongLi(182)	= "28,7,2E27"
		NongLi(183)	= "47,0,16AA"
		NongLi(184)	= "36,0,1AD5"
		NongLi(185)	= "25,5,296B"
		NongLi(186)	= "44,0,14B6"
		NongLi(187)	= "33,0,1A57"
		NongLi(188)	= "23,4,289D"
		NongLi(189)	= "40,0,1D16"
		NongLi(190)	= "29,8,3D0D"
		NongLi(191)	= "48,0,1D52"
		NongLi(192)	= "37,0,1DAA"
		NongLi(193)	= "26,6,2DD4"
		NongLi(194)	= "45,0,156D"
		NongLi(195)	= "35,0,14AE"
		NongLi(196)	= "24,4,353A"
		NongLi(197)	= "42,0,1A2D"
		NongLi(198)	= "31,0,1D15"
		NongLi(199)	= "20,2,364B"
		NongLi(200)	= "39,0,1D53"
	End Sub
	

	'16进制数据转化为原始数据
	Function C16ToData(str)
		Dim dataArr,newData,Ndata,NdataLen
		dataArr	= Split(str,",")
		Ndata	= c16to2(dataArr(2))
		NdataLen= Len(Ndata)-1
		Ndata	= right(Ndata,NdataLen)
		newData	= dataArr(0)
		For i2=1 To NdataLen
			If i2=CInt(dataArr(1)) Then
				newData = newData &","& (Mid(Ndata,i2,1)+29 + Mid(Ndata,13,1)+29)
			Else
				newData = newData &","& Mid(Ndata,i2,1)+29
			End If
		Next
		C16ToData = newData
	End Function

	'10进制转换成2进制
	Function c10to2(str)
		Dim newStr
		newStr = str
		Do While newStr > 0
			c10to2 = CStr(newStr Mod 2) & c10to2
			newStr = newStr \ 2
		Loop
	End Function

	'2进制转换成10进制
	Function c2to10(str)
		Dim i
		For i = 1 To Len(str)
			c2to10 = c2to10 + (CInt(Mid(str, i, 1)) * (2 ^ (Len(str) - i)))
		Next
	End Function

	'2进制转换成16进制
	Function c2to16(str)
		c2to16 = Hex(c2to10(str))
	End Function

	'16进制转换成2进制
	Function c16to2(str)
		c16to2 = c10to2("&H"& str)
	End Function




	'公历该月的天数(y：年份； m：月份)
	Function GongliMonth(y,m)
		If m=2 And ( (y Mod 400 =0) Or (y Mod 4 =0 And y Mod 100 <> 0) ) Then
			GongliMonth=29
		Else
			GongliMonth=GongLi(m)
		End If
	End Function

	'农历月份名称转换(m：月份)
	Function NongliMonth(m)
		If m>=1 And m<=12 Then
			MonthStr=",正,二,三,四,五,六,七,八,九,十,十一,十二"
			MonthStr=Split(MonthStr,",")
			NongliMonth=MonthStr(m)
		Else
			NongliMonth=m
		End If
	End Function

	'农历月份名称转换(d：日)
	Function NongliDay(d)
		If d>=1 And d<=30 Then
			DayStr=",初一,初二,初三,初四,初五,初六,初七,初八,初九,初十,十一,十二,十三,十四,十五,十六,十七,十八,十九,二十,廿一,廿二,廿三,廿四,廿五,廿六,廿七,廿八,廿九,三十"
			DayStr=Split(DayStr,",")
			NongliDay=DayStr(d)
		Else
			NongliDay=d
		End If
	End Function



	'公历转农历(Gdate：公历日期)
	Function GongToNong(Gdate,showMode)
		If IsDate(Gdate)=False Then
			response.write "<script language=javascript>alert('出错！非日期类型，错误会输出1800-1-1')</script>"
			GongToNong="1800-1-1"
			Exit Function
		End If

		If CDate(Gdate) < #1901-2-19# Or CDate(Gdate) > #2100-12-31# Then
			response.write "<script language=javascript>alert('出错！目前公历只支持1901-2-19至2100-12-31，错误会输出1800-1-1')</script>"
			GongToNong="1800-1-1"
			Exit Function
		End If


		Dim Gyear,Gmonth,Gday,Glen,Narr,Nyear,Nmonth,Nday,Ni,Ntype

		Gyear	= Year(Gdate)
		Gmonth	= Month(Gdate)
		Gday	= Day(Gdate)

		Glen	= DateDiff("d",Gyear &"-1-1",Gdate)+1	'获取查询日期到当年1月1日的天数
		Narr	= Split(C16ToData(NongLi(Gyear-NongLiStart)),",")	'获取相应年度农历数据，化成数组Narr
		If Glen<=CInt(Narr(0)) Then
			Nyear	= Gyear-1
			Glen	= CInt(Narr(0))-Glen
			Narr	= Split(C16ToData(NongLi(Nyear-NongLiStart)),",")
			If Glen < CInt(Narr(12)) Then
				Nmonth	= 12
				Nday	= CInt(Narr(12))-Glen
			Else
				Nmonth	= 11
				Glen	= Glen-CInt(Narr(12))
				Nday	= CInt(Narr(11))-Glen
			End If
		Else
			Nyear	= Gyear
			Glen	= Glen-CInt(Narr(0))
			For Ni = 1 To 12
				If Glen>CInt(Narr(Ni)) Then
					Glen=Glen-CInt(Narr(Ni))
				Else
					If Glen>30 Then
						Glen=Glen-CInt(Narr(13))
						Ntype="闰"	'闰月
					End If
					Nmonth	= Ni
					Nday	= Glen
					Exit For
				End If
			Next
		End If

		Select Case showMode
			Case 1
				GongToNong = "农历"& Nyear &"年"& Ntype & NongliMonth(Nmonth) &"月"& NongliDay(Nday)	'效果:农历2000年(闰)四月初六

			Case 2
				GongToNong = "农历"& Nyear &"年"& Ntype & Nmonth &"月"& Nday &"日"	 '效果:农历2000年(闰)4月6日

			Case Else
				GongToNong = Nyear &"-"& Nmonth &"-"& Nday &"&nbsp;"& Ntype		 '效果:2000-4-6 (闰)

		End Select

	End Function




	'农历转公历(Ndate：农历日期； Ntype：是否闰月)
	Function NongToGong(Ndate,Ntype)
		If IsDate(Ndate)=False And Right(Ndate,4)<>"2-29" And Right(Ndate,4)<>"2-30" Then
			response.write "<script language=javascript>alert('出错！非日期类型，错误会输出1800-1-1')</script>"
			NongToGong="1800-1-1"
			Exit Function
		End If
		If CInt(Left(Ndate,4)) < 1901 Or Left(Ndate,4) > 2100 Then
			response.write "<script language=javascript>alert('出错！目前农历只支持1901-1-1至2100-12-29，错误会输出1800-1-1')</script>"
			NongToGong="1800-1-1"
			Exit Function
		End If

		Dim Nyear,Nmonth,Nday,Narr,Nlen,Ni,Gyear,Gmonth,Gday,Gi

'		Nyear	= Year(Ndate)
'		Nmonth	= Month(Ndate)
'		Nday	= Day(Ndate)
		'因为农历日期存在2月29或30，故人工截取年、月、日
		Nyear	= Split(Ndate,"-")(0)
		Nmonth	= Split(Ndate,"-")(1)
		Nday	= Split(Ndate,"-")(2)
		Nmonth	= CInt(Nmonth)
		If Ntype="闰" Or Ntype="1" Then Ntype="闰" Else Ntype=""		'判断查询日期是否是闰月

		Narr	= Split(C16ToData(NongLi(Nyear-NongLiStart)),",")			'获取相应年度农历数据，化成数组Narr
		If Ntype="闰" And UBound(Narr)<=12 Then
			response.write "<script language=javascript>alert('农历"& Ndate &"无闰月，将按照平月计算')</script>"
		End If

		'如果查询的农历是闰月并该年度农历数组存在闰月数据就获取
		If Narr(Nmonth)>30 And Ntype="闰" And UBound(Narr)>=13 Then
			Nday=CInt(Narr(13))+Nday
		End If

		'获取该年农历日期到公历1月1日的天数
		Nlen=Nday
		For Ni=0 To Nmonth-1
			Nlen=Nlen+CInt(Narr(Ni))
		Next

		If Nlen>366 Or (GongliMonth(Nyear,2)<>29 And Nlen>365) Then
		'当查询农历日期距离公历1月1日超过一年时
			Gyear=Nyear+1
			If GongliMonth(Nyear,2)<>29 Then Nlen=Nlen-365 Else Nlen=Nlen-366
			If Nlen>GongLi(1) Then
				Gmonth=2
				Gday=Nlen-GongLi(1)
			Else
				Gmonth=1
				Gday=Nlen
			End If
		Else
			Gyear=Nyear
			For Gi=1 To 12
				If Nlen>GongliMonth(Gyear,Gi) Then
					Nlen=Nlen-GongliMonth(Gyear,Gi)
				Else
					Gmonth=Gi
					Gday=Nlen
					Exit For
				End If
			Next
		End If

		NongToGong=Gyear &"-"& Gmonth &"-"& Gday
	End Function

End Class
%>