<%
' +----------------------------------------------------------------------
' | POPASP [ ASP MVC ]
' +----------------------------------------------------------------------
' | Copyright (c) 2016 http://popasp.com All rights reserved.
' +----------------------------------------------------------------------
' | Author: popasp <1737025626@qq.com>
' +----------------------------------------------------------------------
Class POPASP_ASPBBS
	'这个文件的代码块是为了服务于CMS
	Public content,currentPage,dictReplace,replaceContent,matchValue,listRepContent,htmlPageTotal,CommonTable,indexLinkPrefix,cmsPrefix,selfTpl
	Private labelRule,sitePath,needCached,cacheLeftLabel,cacheRightLabel,cacheEndLabel
	Private repKey,dictLabel,dictHtmlPath
	Private staticName,dataName
	Private templateDir,labelStr,cms_home_path,authorDict,blockLoopMax,blockloopCounter
	Private cmsLabelPrefix,blockLabelDict,loop4dataName,loop4keyName
	Private escape_label,files_counter
	Public loopStr,RealLinkPrefix,ClassType
	
	Public page_firstlink,page_prevlink,page_nextlink,page_lastlink,page_total,page_pagesize,page_current,page_count,page_bar,page_numlist,page_prev,page_next,linkPrefix,baseTable
	
	'下面这三个参数，分别对应的是 [news:title] 中的 "[" 　、  "]"  、 "news"
	Public ContentPageLeftLabel,ContentPageRightLabel,ContentPageLabel
	
	'初始化类
	Private Sub Class_Initialize()
		on error resume next
		set dictReplace = POP_MVC.SCD

		htmlPageTotal = 0
		sitePath = POP_MVC.config("sitePath")
		CommonTable = "table"
		Call initLinkPrefix
		cmsPrefix = POP_MVC.config("CMS_TAG_LABEL")	
		cmsLabelPrefix = POP_MVC.config("CMS_SELF_TAG_LABEL")	
		
		if POP_MVC.config("cms_home_path") <> "" then
			cms_home_path = POP_MVC.rtrim(POP_MVC.config("cms_home_path"),"/")
		else
			cms_home_path = POP_MVC.appPath
		end if
		
		loop4dataName = "data"
		loop4keyName  = "key"
		
		baseTable = "config"
		
		page_firstlink = "[page:firstlink]"
		page_prevlink = "[page:prevlink]"
		page_nextlink = "[page:nextlink]"
		page_lastlink = "[page:lastlink]"
		page_total = "[page:total]"
		page_pagesize = "[page:pagesize]"
		page_current = "[page:current]"
		page_prev = "[page:prev]"
		page_next = "[page:next]"
		page_count = "[page:count]"
		page_bar = "[page:bar]"
		page_numlist = "\[page:\d+\]"
		ContentPageLeftLabel	= "["
		ContentPageRightLabel	= "]"
		ContentPageLabel		= "news"	
		escape_label = "#QQ_1737025626_POPASP_ESCAPE_QQ_GROUP_124648143_" & POP_MVC.String.uniqid & "_#"
		files_counter = 0
		ClassType = typename(Me)
		staticName = POP_MVC.config("STATIC_NAME")
		dataName = POP_MVC.config("DATA_NAME")
		
		cacheLeftLabel = "<!--aspbbs:cache/"
		cacheRightLabel = "/-->"
		cacheEndLabel = "<!--/aspbbs:cache/-->"
	End Sub
	
	Private Sub Class_Terminate()
		set dictReplace=nothing
		set blockLabelDict = nothing
		set authorDict = nothing
		set dictLabel = nothing
		set dictHtmlPath = nothing
	End Sub
	
	Public Function loadFile(Byval filePath)
		loadFile = POP_MVC.file_get_contents_charset( filePath , config.Charset )
	End Function
	
	'加载文件
	Public Function load(Byval filePath)
		content=loadFile(filePath)
		templateDir = POP_MVC.file.dir( filePath )
		load = content
	End Function	

	
	'解析模板文件，生成html
	Public Property Get parseHtml()		
		blockloopCounter = 0
	
		'加载其他的控制器方法 Call A_("ctrl/method")，只需要写{iaspcms:action:ctrl/method}
		parseAction()	
	
		'加载头部与尾部文件
		parseTopAndFoot()
		'加载引用模板文件
		parseAuxiliaryTemplate() 
		parseMvcTpl()

		RemoveComment()
		
		on error resume next
			'如果不存在ParseBeforeLabelHandler，返回"类型不匹配"可以忽略的错误
			ParseBeforeLabelHandler
			'这个方法用来处理在模板替换前预先对模板内容的处理
		err.clear		
		parseLabel()
		
		blockloopCounter = 0
	End Property
	
	'解析Call A_("ctrl/method")
	'{iaspcms:action:ctrl/method}
	Public Property Get parseAction()
		on error resume next
		dim labelRule,match,matches
		if inStr( content,"{" & cmsPrefix & ":action:" ) > 0 then
			labelRule = "\{" & cmsPrefix & ":action:\s*([^}]+)(?!{" & cmsPrefix & ":)}"		
			set matches = POP_MVC.String.reg_exec( content,labelRule , "igm" )		
			for each match in matches
				labelStr = match.SubMatches(0)				
				execute( "Call A_(""" & labelStr & """)" )
				content = replace( content, match.value ,"" )
			next
			set matches = nothing
		end if	
	End Property
	
	'删掉注释
	Public Property Get RemoveComment
		dim left_delimiter,right_delimiter
		' The left delimiter used for the template tags.
		left_delimiter  =  "{"

		' The right delimiter used for the template tags.
		right_delimiter =  "}"	
		
		' 一行注释的替换 {//注释内容 }
		content = POP_MVC.String.reg_replace( content , "", left_delimiter & "//.*?" & right_delimiter , "gim")
		
		' 多注释的替换 {/*注释内容*/}
		content = POP_MVC.String.reg_replace( content , "" , left_delimiter & "\/\*[\s\S]*?\*\/" & right_delimiter , "gim")	
	End Property
	
	'压缩html
	Public Property Get CompressHtml
		if guestConfig.html_compress = 1 then
			'content = POP_MVC.String.reg_replace ( content , "" , "[\t ]*[\r\n]+[\t ]*" , "gm" ) 
			content = POP_MVC.String.htmlCompress( Content )
			content = POP_MVC.String.reg_replace ( content , "$1" , "\s*[-|_]*\s*Powered\s+By[^<>]+?(</title>)" , "mi" ) 
			content = POP_MVC.String.reg_replace ( content , " - Powered By " & POP_MVC.config("CMS_POWER_NAME") & " " & POP_MVC.config("CMS_VERSION") & "$1" , "(</title>)" , "mi" ) 
			'POP_MVC.String.htmlCompress( Content )
		end if
		
		if POP_MVC.config("sitePath") <> "" then
			Content = POP_MVC.String.reg_replace( Me.Content , "$1" &  POP_MVC.config("sitePath") & "/Upload/" ,  "(""|')/upload/" , "gim" )
		end if	
	End Property
	
	'输出
	Public Property Get Output
		CompressHtml()
		Response.write Content
	End Property 	
	
	'解析头部和底部
	Public Property Get parseTopAndFoot()
		dim sharestr,aliax
		sharestr=""


		if inStr(content, getTagLabel("top") ) > 0 then 
			if POP_MVC.file.isFile( templateDir & "top" & config.fileExt ) then
				content=replace(content,getTagLabel("top"),loadFile( templateDir & "top" & config.fileExt ))
			elseif POP_MVC.file.isFile( templateDir & "head" & config.fileExt ) then
				content=replace(content,getTagLabel("top"),loadFile( templateDir & "head" & config.fileExt ))
			end if
		
		end if
		if instr(content,getTagLabel("head")) > 0 then 
			if POP_MVC.file.isFile( templateDir & "head" & config.fileExt ) then
				content=replace(content,getTagLabel("head"),loadFile( templateDir & "head" & config.fileExt))
			elseif POP_MVC.file.isFile( templateDir & "head" & config.fileExt ) then
				content=replace(content,getTagLabel("head"),loadFile( templateDir & "top" & config.fileExt))
			end if
		end if
		if inStr(content,getTagLabel("left")) > 0 then content=replace(content,getTagLabel("left"),loadFile( templateDir & "left" & config.fileExt))
		if inStr(content,getTagLabel("comm")) > 0 then content=replace(content,getTagLabel("comm"),loadFile( templateDir & "comm" & config.fileExt))
	End Property

	'解析辅助模板
	Public Property Get parseAuxiliaryTemplate()
		Dim pattern,matches,match,srcTemplate,tplPath
		pattern = "\{" & cmsPrefix & ":template([\s\S]*?)\}"
		do while inStr( content ,"{" & cmsPrefix & ":template" ) > 0
			set matches = POP_MVC.String.reg_exec(content,pattern,"gim")
			for each match in matches			
				srcTemplate = parseArr(match.SubMatches(0))("src")				

				if mid( srcTemplate , 1 , 1) = "$" then
					srcTemplate = V_( mid( srcTemplate , 2) )
				end if
				srcTemplate = POP_MVC.rtrim( srcTemplate , config.fileExt ) & config.fileExt
				if inStr( srcTemplate , "/" ) > 0 then
					tplPath = getTemplatePath( srcTemplate )
				else
					tplPath = templateDir & srcTemplate
				end if
				content=replaceStr(content,match,loadFile( tplPath ))
			next
			set matches = nothing
		loop
		parseAuxiliaryTemplate = content
	End Property
	
	'解析辅助模板
	'加载框架中模板文件，并解析
	Public Property Get parseMvcTpl()
		Dim pattern,matches,match,srcTemplate
		pattern = "\{" & cmsPrefix & ":tpl([\s\S]*?)\}"
		do while inStr( content , "{" & cmsPrefix & ":tpl" )  > 0
			set matches = POP_MVC.String.reg_exec(content,pattern,"gim")		
			for each match in matches			
				srcTemplate = parseArr(match.SubMatches(0))("src")	
				
				content=replaceStr(content,match,loadFile( Me.getTplPath(srcTemplate) ))
			next
			set matches = nothing
		loop
		parseMvcTpl = content
	End Property
	

	'解析标签
	Public Property Get ParseLabel
		on error resume next
		dim matches,match,labelRule,settingLables,dContainer,obj,tempStr,loopCounter,cachePath,keylen,lenCmsPrefix,keys,pos,homePage,key,k,startTime,SortID,parseBool,labelStrKey
		
		if inStr( content,"{:"  ) > 0 then
			Call parseExecExp( "{" , "}" )
		end if
		
		'自定义标签替换
		if inStr( content, "{" & cmsLabelPrefix & ":" ) > 0 then
			Call ParseSelfLabel
		end if		
		
		
		labelRule = "\{" & cmsPrefix & ":\s*([\w\.]+)(?!{" & cmsPrefix & ":)}"		
		
		startTime = timer
		set matches = POP_MVC.String.reg_exec( content,labelRule , "igm" )		
		set dContainer = POP_MVC.SCD
		blockloopCounter = 0
		BlockLoopMax = 10
		loopCounter = 1
		lenCmsPrefix = len( cmsPrefix )
		
		'{" & cmsPrefix & ":sitepath} 网站终极目录(可放在二级目录,其它语言则在三级目录)
		'{" & cmsPrefix & ":username} 当前登陆用户
		'{" & cmsPrefix & ":userright} 用户权限，用户权限的读取0为超级管理员，1为注册用户，2为游民
		'{label:****} 自定义标签
		'{" & cmsPrefix & ":onlineservice} 在线客服
		'{" & cmsPrefix & ":kf} 其它客服系统
		'{" & cmsPrefix & ":floatad} 漂浮广告
		'{" & cmsPrefix & ":coupletad} 对联广告
		'{" & cmsPrefix & ":windowad} 弹出广告
		'{" & cmsPrefix & ":onekeyshare} 在文章中可调用一键分享
		'{" & cmsPrefix & ":version}	程序版本信息
		'{" & cmsPrefix & ":versionid}	程序版本号
		for each match in matches
			labelStr = LCase(match.SubMatches(0))
			if guestConfig.exists__(labelStr) then
				content = replace( content, match.value ,guestConfig.get__(labelStr) )
			elseif config.exists__(labelStr) then
				content = replace( content, match.value ,config.get__(labelStr) )
			else
				labelStrKey = LCase(labelStr)
				select case labelStrKey
					case "sitepath" : content = replace( content, match.value ,sitePath )
					case "sitetplpath" : content = replace( content, match.value ,sitePath & "/Templates/" & config.defaultTemplate )
					case "versionid" : content = replace( content, match.value ,currentversion )
					case "version" : content = replace( content, match.value ,POP_MVC.config("CMS_VERSION") )
					case "sitelogo" : content = replace( content, match.value ,config.sitelogourl )			
					case "checkcode" : content = replace( content, match.value ,P_("auto").cmsverify )
					case "checkimg" : content = replace( content, match.value ,P_("auto").cmsverify4code )
					case "indexasp" : content = replace( content, match.value ,left(indexLinkPrefix , len(indexLinkPrefix)-1 ) )
					case "indexprefix" : content = replace( content, match.value ,linkPrefix )
					case "siteurl" : content = replace( content, match.value ,POP_MVC.http_host() )
					case "homepage"
						content = replace( content, match.value ,getHomePage() )
						
					'''''下面这几个是最后才替换的，所以先“保护”起来，>2.5版，2021.1.20
					case "runtime","totalquery","runinfo"
						content = replace( content, match.value ,escape_label & labelStrKey )
					'''''''''''''''''''''''''''''''''''''''''	
					
					case else
						if inStr( labelStr, "." ) > 1 then
							content = replace( content, match.value , repnull(V_( match.SubMatches(0) )) )
						'2.1版新增
						elseif POP_MVC.tpl_vars.exists( match.SubMatches(0) ) then
							content = replace( content, match.value ,repnull(POP_MVC.tpl_vars( match.SubMatches(0) )) )
						else
							dContainer(labelStr) = match.value
						end if
				end select				
			end if
		next
		set matches = nothing
	
		
		Call POP_MVC.cmsPushTime( startTime,"替换单标签{" & cmsPrefix & ":XXX}" )
		
		SortID = POP_MVC.get("SortID")
		
		if SortID = "" then
			for each key in dContainer				
				tempStr = ""
				parseBool = true
				select case key
					case "sortid" : tempStr = 0
					case "sortname" : tempStr = "首页"
					case else : parseBool = false
				end select
				if parseBool then
					content=replace(content,dContainer(key),tempStr)
					dContainer.remove(key)
				end if
			next
			
			if POP_MVC.get("a") = "search" then
				content=replace(content, getTagLabel("textlink") , "搜索：" & POP_MVC.get("keys") )
			end if			
		end if
		
		set matches = nothing		

		if inStr( content,"{" & cmsPrefix & ":func:" ) > 0 or inStr( content,"{" & cmsPrefix & ":execute:" ) > 0 then
			labelRule = "\{" & cmsPrefix & ":(?:func|execute):\s*([^}]+)(?!{" & cmsPrefix & ":)}"		
			set matches = POP_MVC.String.reg_exec( content,labelRule , "igm" )		
			for each match in matches
				labelStr = match.SubMatches(0)				
				if inStr(labelStr , "[") < 1 and  inStr(labelStr , "]") < 1 then
					labelStr = match.SubMatches(0)
					labelStr = getMvcTplVars( labelStr )		
					if inStr( match.value, ":func:" ) > 0 then					
						execute( "tempStr =" & labelStr )	
					elseif inStr( match.value, ":execute:" ) > 0 then
						execute( labelStr )
					end if
					content = replace( content, match.value ,tempStr )
				end if
			next
			set matches = nothing
		end if		
		
		'解析{isaspcms:arealist}，因cms不同
		Call parseAreaList

		
		Call parseBlockLabel("navlist")
		
		Call parseBlockLabel("cache")

		Call parseBlockLabel("")		
		
		if inStr( content, "{/" & cmsPrefix & ":" ) > 0 then
			Call parseBlockLabel("")
		end if
		
		if inStr( content, "{/" & cmsPrefix & ":" ) > 0 then
			Call parseBlockLabel("")
		end if
	
		if inStr( content,"{" & cmsPrefix & ":func:" ) > 0 then
			labelRule = "\{" & cmsPrefix & ":func:\s*([^}]+)(?!{" & cmsPrefix & ":)}"		
			set matches = POP_MVC.String.reg_exec( content,labelRule , "igm" )		
			for each match in matches
				labelStr = match.SubMatches(0)
				labelStr = match.SubMatches(0)
				labelStr = getMvcTplVars( labelStr )				
				execute( "tempStr =" & labelStr )
				content = replace( content, match.value ,tempStr )
			next
			set matches = nothing
		end if
		
		if inStr( content, "{if" ) > 0 then
			parseIf("")
		end if		

		do while inStr( content , "<!--/aspbbs:cache/-->" ) > 0 
			key = POP_MVC.String.getInStr( content,cacheLeftLabel,cacheRightLabel )
			match = POP_MVC.String.getInStr(  content , cacheLeftLabel & key & cacheRightLabel , cacheEndLabel )
			needCached = true
			cachePath = cms_home_path & "/Runtime/Cache/" & key & ".txt"
			Call cache_put_contents( cachePath , match )
			content = replace( content,cacheLeftLabel & key & cacheRightLabel,"<!-- ASPBBS CACHE SAVED ( " & now() & " ) -->" ,1,1 )
			content = replace( content,cacheEndLabel,"<!-- ASPBBS CACHE END -->" ,1,1 )
		loop		
		
		'''''将前面保护起来的几个单标签进行替换
		content = replace( content, escape_label & "runtime" , POP_MVC.runtime )
		content = replace( content, escape_label & "totalquery" , POP_MVC.num_db_query )
		content = replace( content, escape_label & "runinfo" , "运行" & POP_MVC.runtime & "秒&nbsp;"   & POP_MVC.num_db_query & "次sql查询"  )		
		
		'var_Export dContainer
		Call L_( ClassType & ".parseLabel" )
	End Property
	
	
	'解析块标签
	Public Property Get parseBlockLabel( labelName )
		on error resume next
		dim match,loopCounter,cachePath,keylen,lenCmsPrefix,key,k,SortID,moreParse,rsObj,cachekey

		if blockloopCounter >= BlockLoopMax then
			exit Property
		end if
		moreParse = array()
		
		SortID = POP_MVC.get("SortID")
		
		loopCounter = 0
	
		lenCmsPrefix = len( cmsPrefix )
		
	
		'解析块标签
		set blockLabelDict = getBlockLabelsDict(content,labelName,"")


		for each k in blockLabelDict			
			set match = blockLabelDict(k)
			
				
			key = match("label")
if inStr( content,match("left_flag") ) > 0 then
			cachePath = ""
			cachekey = ""
			needCached = false
			replaceContent = match("full_content")
			matchValue = match("full_content")
			labelStr = match("attr")
			loopStr = match("content")
			repKey = POP_MVC.String.reg_replace( match("full_content"),"","\W+","igm" )

			keylen = len( repKey )
			repkey = mid( repKey, lenCmsPrefix + len( key ) + 1 , keylen - (lenCmsPrefix + len( key ))*2 )	
			
			if inStr( match("left_flag") , "cachekey" ) > 0 then
				cachekey = POP_MVC.String.reg_find( match("left_flag") , "\bcachekey=([^\s]+?)\b" , 1, "i" )
				cachePath = cms_home_path & "/Runtime/Cache/" & cachekey & ".txt"
			end if
			
			if keylen > 300 then
				repKey = left( repKey, len( match("left_flag") ) ) & mid( repKey, Cint( keylen/3 ) , 80 ) & right( repKey, 80 )
			end if
				select case key					
					case "looparr"
						if inStr( content, match("full_content") ) > 0 then
							Call ParseData( "looparr" , "" )						
							dictReplace( repKey ) = replaceContent	
							content = replace( content, match("full_content") , replaceContent )
						end if
					case "loopdata"
						if inStr( content, match("full_content") ) > 0 then
							Call ParseData( key , "" )
							dictReplace( repKey ) = replaceContent						
							content = replace( content, match("full_content") , replaceContent )
						end if
					case "file"
						if dictReplace.exists( repKey ) then
							content = replace( content, match("full_content") , dictReplace( repKey ) )
						else
							Call ParseFiles( POP_MVC.get("page") , "file" , "" )
							dictReplace( repKey ) = replaceContent						
							content = replace( content, match("full_content") , replaceContent )
						end if
					case "xml"
						if dictReplace.exists( repKey ) then
							content = replace( content, match("full_content") , dictReplace( repKey ) )
						else
							Call ParseXml( POP_MVC.get("page") , "xml" , "" )
							dictReplace( repKey ) = replaceContent						
							content = replace( content, match("full_content") , replaceContent )
						end if	
					case "cache"
						if is_cached( cachePath, match("left_flag") ) then
							content = replace( content, match("full_content") , "<!-- ASPBBS CACHE START ( " & POP_MVC.file.mtime(cachePath) & " ) -->" & Me.loadFile(cachePath) & "<!-- ASPBBS CACHE END -->" )
						else
							listRepContent = match("full_content")
							if needCached then
								listRepContent = replace( listRepContent, match("left_flag") , "<!--aspbbs:cache/" & cachekey & "/-->" )
								listRepContent = replace( listRepContent, "{/aspbbs:cache}" , "<!--/aspbbs:cache/-->" )
							else
								listRepContent = replace( listRepContent, match("left_flag") , "" )
								listRepContent = replace( listRepContent, "{/aspbbs:cache}" , "" )
							end if
							content = replace( content, match("full_content"),listRepContent )
						end if						
					case CommonTable,"looprs"
						if is_cached( cachePath, match("left_flag") ) then
							content = replace( content, match("full_content") , Me.loadFile(cachePath) & "<!-- 来自缓存文件 -->" )
							
							
							if inStr(match("left_flag"),"page=1") > 0 then								
								set rsObj = POP_MVC.tpl_vars( POP_MVC.String.getInStr(match("left_flag"), loop4dataName & "=" , " " ) )
								Me.content = replacePageLabel( Me.content , rsObj.recordCount, rsObj.pagesize, POP_MVC.get("page") , SortID ,key,"", key )
								listRepContent = Me.content
							end if
 
						else	
							listRepContent = Me.content
							Call Me.parseList( SortID , POP_MVC.get("page") ,key,"", key )
							Me.content = replace( listRepContent, match("full_content") , replaceContent )							
							Call cache_put_contents( cachePath , replaceContent )
						end if
					case else

				End Select
				
			else
				POP_MVC.arr.push moreParse , key
			end if

				loopCounter = loopCounter + 1
		next	
		
		
		loopCounter = loopCounter + 1
		
		blockloopCounter = blockloopCounter + 1
		

		if ubound(moreParse) > -1 then
			Call parseBlockLabel( moreParse )
		end if

		Call L_( ClassType & ".parseBlockLabel" )
	End Property
	
	Private Sub cache_put_contents( cachePath,cacheContent )
		if needCached then 
			call POP_MVC.file_put_contents_without_bom( cachePath , cacheContent )
		end if
	End Sub
	
	'清除缓存
	Public Property Get clearCompile
		Call POP_MVC.file.remove(cms_home_path & "/Runtime/Compile/")	
	End Property
	
	'清除缓存
	Public Property Get clearCache
		Call POP_MVC.file.remove(cms_home_path & "/Runtime/Cache/")	
	End Property
	
	'清除过程数据
	Public Property Get clearRuntime
		Call POP_MVC.file.remove(cms_home_path & "/Runtime/")	
	End Property	
	
	'判断模板中的块是否在缓存期内
	Private function is_cached( byval cachePath ,  byref left_flag )
		dim cache_lifetime,cacheLife
		cache_lifetime = guestConfig.ListCacheLifeTime
		needCached = false
		
		if inStr( left_flag , "cache=0" ) > 0 then
			is_cached = false
			Exit Function
		end if
		
		if inStr( left_flag , "cachekey=" ) < 1 then
			is_cached = false
			Exit Function
		end if
		
		if inStr( left_flag , "cache=" ) > 0 then
			cacheLife = POP_MVC.String.reg_find( left_flag , "\bcache=([\d-]+)\b" , 1, "i" )
			cacheLife = CLng( cacheLife )
			if cacheLife = -1 then
				cacheLife = cache_lifetime
			end if
			
			if isNul(cacheLife) then
				cacheLife = 0
			end if
		else		
			cacheLife = cache_lifetime
			if cacheLife > cache_lifetime then cacheLife = cache_lifetime
		end if
		
		if cacheLife < 1 then
			is_cached = false
			Exit Function
		end if
		
		needCached = true
		'		缓存文件不存在
		if Not POP_MVC.File.isExists( cachePath )  Then
			is_cached = false
			Exit Function
		'				缓存文件过期
		ElseIf dateCompare(now(),POP_MVC.file.mtime( cachePath )) > cacheLife Then	
			is_cached = false
			Exit Function
		End If	
		
		is_cached = true
		needCached = false				
	End Function
	
	'程序中判断某个文件是否缓存
	Function isCached( cacheKey, cacheLife )
		dim cache_lifetime
		
		if isNul( cacheLife ) then
			cache_lifetime = guestConfig.ListCacheLifeTime
		else 
			cache_lifetime = cacheLife
		end if
		isCached = false
		

		if cache_lifetime <= 0 then
			exit function
		end if
		
		cachePath = cms_home_path & "/Runtime/Cache/" & cacheKey & ".txt"
		if not POP_MVC.file.isFile( cachePath ) then
			exit function
		end if
		
		If dateCompare(now(),filemtime(cachePath)) > cache_lifetime Then	
			Exit Function
		End If
		
		isCached = true	
	End Function
	
	Function filemtime(filename)
		filemtime = POP_MVC.File.mtime(filename)
	End Function
	
	'如果date1>date2返回正，否则返回负数
	Function dateCompare( date1,date2 )
		dateCompare = DateDiff("s",date2,date1)
	End Function
	
	Public Property Get getSelfLabel(labelName)
		if isEmpty( dictLabel ) then 
			set dictLabel = B_( baseTable ).from("{prefix}Labels").field("LabelName,LabelContent").getkeyvalue
		end if
		getSelfLabel = dictLabel( labelName )
	end Property
	
	'解析自定义标签替换
	Public Property Get ParseSelfLabel
		dim labelRule,match,matches,repKey,tempStr,arr,keys
		if isEmpty( dictLabel ) then 
			set dictLabel = B_( baseTable ).from("{prefix}Labels").field("LabelName,LabelContent").getkeyvalue
		end if
		if dictLabel.count > 0 then
			labelRule = "{" & cmsLabelPrefix & ":([\s\S]*?)}"	
			set matches = POP_MVC.String.reg_exec( content,labelRule , "igm" )		
			for each match in matches
				repKey = match.SubMatches(0)
				if dictLabel.exists( repKey ) then
					tempStr = dictLabel(repKey)
					tempStr = POP_MVC.String.decodeHtml(tempStr)
					tempStr = POP_MVC.trim( tempStr, "$$$" )
					'如果在自定义标签内容中发现$$$，则以$$$分割，进行随机显示，否则直接替换
					if inStr( tempStr, "$$$" ) > 0 then
						arr = split(tempStr,"$$$")
						
						if config.runMode = 1 then
							keys = "POPASP_SELF_LABEL_" & B_( baseTable ).from("Labels").where("LabelName ='" & repKey & "'").field("LabelID").getOne
							tempStr = "var " & keys & " = " & js_encode( arr ) & ";" & vbCrLf
							tempStr = tempStr & keys & " = " & keys & "[Math.floor(Math.random()*" & keys & ".length)];" & vbCrLf
							tempStr = tempStr & "document.write(" & keys & ");" & vbCrLf
							tempStr = "<script type=""text/javascript"">" & vbcrlf & tempStr
							tempStr = tempStr &	"</script>"								
						else
							Randomize
							tempStr = Arr(CLng(Rnd * ubound(arr)))
						end if
					end if
					content = replace( content, match.value, tempStr )
				else
					POP_MVC.warning("有未解析的标签{" & cmsLabelPrefix & ":" & repKey & "}")
				end if
			next
			set matches = nothing
		end if
	End Property
	
	Public Sub ParseCommonTable( id, tableName )
		matchValue = content
		labelStr = ""
		loopStr = content
		replaceContent = content
		Call ParseList( id , 0, CommonTable, tableName ,"" )	
		content = replaceContent
	End Sub
	
	'分页条
	Function replacePageLabel(ByVal str ,ByVal dTotal, ByVal dPerpage, ByVal dPage, ByVal dID, ByVal sLinkType, ByVal sShowType, ByVal sKeys )
		dim pageLabel,PageCount,obj,k,matches,match,dict,b1,b2,fieldArr,labelArr,i,loopStrTotal
		dim tmp
		
		if isNul( POP_MVC.get("page") ) then
			str= replace( str, page_current , 1 )
		else
			str= replace( str, page_current , POP_MVC.get("page") )
		end if
		set obj = P_("cmspage")
		'自定义分页	
		b1= inStr( str, "[page:" ) > 0
		b2= inStr( str , "{" & sLinkType & ":pagenumber" ) > 0	
		


		if b1 or b2 then
				Call obj.init( dTotal,dPerpage,dPage,dID,sLinkType,sShowType,sKeys )
			'if b2 then
					
				set matches = getBlockLabelsDict( str , "pagenumber" , sLinkType )
			
				for each k in matches
					set match = matches(k)
					if dTotal = 0 then
						str = replace( str , match("full_content") , "" )
					else
						set labelArr = parseArr( match("attr") )
						if not labelArr.exists( "len" ) then
							labelArr("len") = 10
						end if

						Call obj.NumList( labelArr("len") )
						
						loopStrTotal = ""
						'if obj.totalPage > 1 then
							for i = obj.leftPage to obj.rightPage
								tmp = replace( match("content") , "[pagenumber:page]" , i )
								tmp = replace( tmp , "[pagenumber:link]" , obj.PageLink(i) )
								loopStrTotal = loopStrTotal & tmp
							next
						'end if
						str = replace( str , match("full_content") , loopStrTotal )
					end if
				next
			'end if

			if isNul( obj.page ) then
				obj.page = 1
			end if
			

			
			str= replace( str, page_firstlink , obj.FirstLink )
			str= replace( str, page_prevlink , obj.PrevLink )
			str= replace( str, page_nextlink , obj.NextLink )
			str= replace( str, page_lastlink , obj.LastLink )
			str= replace( str, page_prev , obj.page - 1 )
			str= replace( str, page_next , obj.page + 1 )
			str= replace( str, page_total , obj.total )
			str= replace( str, page_pagesize , obj.perpage )
			
			str= replace( str, page_count , obj.totalPage )
			str= replace( str, page_bar , obj.bar(10) )
			pageLabel = POP_MVC.String.reg_fetch( str, page_numlist , "" )
			PageCount = POP_MVC.String.reg_fetch( pageLabel , "\d+" , "" )
			str= replace( str, pageLabel , obj.NumList( PageCount ) )			
		end if	
		replacePageLabel = str
	End Function
	
	Function replacePageList(byVal str,ByVal pageListType, dTotal,dPerpage,dPage,dID,sLinkType,sShowType,sKeys )
		dim matchesPagelist,matchPagelist,labelRulePagelist,lenPagelist,pageSeperator,strPagelist
		labelRulePagelist = "\["&pageListType&":pagenumber([\s\S]*?)\]"
		set matchesPagelist = POP_MVC.String.reg_exec(str,labelRulePagelist,"im")
		if matchesPagelist.count > 0 then
			Call P_("cmspage").init( dTotal,dPerpage,dPage,dID,sLinkType,sShowType,sKeys )
			for each matchPagelist in matchesPagelist	
				if P_("cmspage").totalPage=0 then
					str = replace(str,matchPagelist.value,"")
				else
					lenPagelist = parseArr(matchPagelist.SubMatches(0))("len")
					pageSeperator = parseArr(matchPagelist.SubMatches(0))("sep")
					if not isNul( pageSeperator ) then
						P_("cmspage").seperator = pageSeperator
					end if
					
					if isNul(lenPagelist) then lenPagelist = 10 else lenPagelist = cint(lenPagelist)

					strPagelist = P_("cmspage").bar( lenPagelist )
					str = replace(str,matchPagelist.value,strPagelist)
				end if
			next
		end if
		replacePageList = str		
	End Function	
	
	'用来解析文件
	Public Function parseFiles( ByVal currentPage,ByVal pageListType,typeIds )
		on error resume next
	    dim labelRuleField,labelArr,matchesfield,tempStr,str,k	
		Dim loopstrTotal,i,nloopstr,matchfield,fieldNameArr,fieldName,fieldArr,typeStr,key,item,parseBool		
		Dim path,listType,objFolder,file,objFiles,arr,start_,end_,perpage,pageBool,sitePathLen,extStr,extName	
		Dim startTime : startTime = timer()
		labelRuleField = typeIds & pageListType
		
		set labelArr = parseArr(labelStr)
		
		'遍历文件方式方法
		listType = "file"
		if labelArr.exists("type") then
			listType = labelArr("type")
		end if
		
		if labelArr.exists("ext") then
			extStr = POP_MVC.trim( labelArr("ext") , "|" )
			extStr = POP_MVC.String.reg_replace( extStr , "|" , "\W" , "g" )
			extStr = "|" & extStr & "|"
		end if
		
		path = labelArr("path")
		
		if left(path,1) = "$" then
			path = V_( mid(path ,2 ) )
		else
			path = sitePath & "/" & POP_MVC.ltrim( path , "/" )
		end if
		
		sitePathLen = Len(POP_MVC.realPath(sitePath & "/")) + 2
		
		if currentPage = "" then
			currentPage = 1
		end if
		
		perpage = getPageSize( labelArr ,10 )
		
		pageBool = false

		if listType = "file" then
			set objFolder=POP_MVC.fso.GetFolder( POP_MVC.realPath(path) )		
			set objFiles=objFolder.Files			
		elseif listType = "folder" then
			set objFolder=POP_MVC.fso.GetFolder( POP_MVC.realPath(path) )		
			set objFiles=objFolder.SubFolders	
		end if
		
		set matchesfield = getInnerLabelsDict( loopStr , labelRuleField )
		i = 0
		listIndex = 1
		set fieldArr = D_
		For Each file In objFiles
			
			if extStr <> "" then
				extName = POP_MVC.file.extName( array(file.name,1) )
			end if

			if extStr = "" or ( extStr <> "" and inStr( extStr , "|" & extName & "|" ) > 0 ) then
			
				if labelArr.exists("num") then
					if CStr(labelArr("num")) =  CStr(i)  then
						exit for
					end if
				end if

				nloopstr=loopStr
				
				for each k in matchesfield
					set matchfield = matchesfield(k)
					fieldName = matchfield("label")
					if matchfield("attr") <> "" then
						set fieldArr = parseAttr( matchfield("attr") )
					else
						fieldArr.removeAll
					end if					
					tempStr = ""
					parseBool = true
					select case fieldName
						case "i"  : tempStr = listIndex
						case "filepath" : tempStr = replace(mid( file.path , sitePathLen ) , "\" , "/")
						case "basename" : tempStr = POP_MVC.file.baseName( array(file.name,1) )
						case "extname"  : tempStr = POP_MVC.file.extName( array(file.name,1) )
						case "date" : tempStr = file.DateLastModified
						case else : Execute( "tempStr = file." & fieldName )							
					end select
					
					if fieldArr.count > 0 then
						tempStr = FormatTempStr( tempStr , fieldArr , matchfield("full_content") ,file )
					end if
					nloopstr = replaceStr(nloopstr,matchfield("full_content"), tempStr )
				next
				
				if i >= (currentPage - 1) * perpage  and i < currentPage * perpage  then
					if labelArr("order") = "0" then
						loopstrTotal = nloopstr & loopstrTotal
					else
						loopstrTotal = loopstrTotal & nloopstr
					end if					
				end if
			
				listIndex = listIndex + 1
				i = i +1					
			end if
			files_counter = files_counter + 1
		Next
		
	
			set matchesfield = nothing
			replaceContent = replace(replaceContent,matchValue,loopstrTotal)	
			content = replacePageLabel( content , i, perpage  , currentPage , POP_MVC.get("SortID"), "file" , POP_MVC.get("template") ,"file" )			
			content = replacePageList( content , "file" , i, perpage , currentPage , POP_MVC.get("SortID"), "file" , POP_MVC.get("template") ,"file" )			
			
		if instr(loopstrTotal,"{" & cmsPrefix & ":sub" & parseListType  )>0 then
			str = "sub"
		else
			if str="" then str=0
			str = str + 1		
		end if
		'if str > 5 then exit function
		
		if instr(loopstrTotal,"{" & cmsPrefix & ":"& str &pageListType)>0 then 		
			set matches = getBlockLabelsDict( loopstrTotal , str &pageListType , ""  )
			for each k in matches					
				set match = matches(k)
				key = match("label")
				matchValue = match("full_content")					
				labelStr = match("attr")								
				loopStr = match("content")		
				Call parseFiles( currentPage,pageListType , str )
			next
			set matches = nothing
		end if	

		files_counter = 0
		Call L_( ClassType & ".parseFiles " & pageListType )
	End Function
	
	'用来解析xml
	Public Function parseXml( ByVal currentPage,ByVal pageListType,typeIds )
		on error resume next
	    dim labelRuleField,labelArr,matchesfield,tempStr,str,listIndex,k
	
		Dim loopstrTotal,i,nloopstr,matchfield,fieldName,attr,fieldArr,key,item,parseBool
		
		Dim listType,perpage,pageBool
		Dim data,nodes,node,xmlobj
		
		
		dim startTime : startTime = timer()
		
		labelRuleField = typeIds & pageListType
		
		set labelArr = parseArr(labelStr)
		
		'采用何种方式
		
		if labelArr.exists("type") then
			listType = labelArr("type")
		else
			listType = POP_MVC.config("XML_TYPE")
		end if
		
		if listType = "" then
			listType = "file"
		end if
		
		set  xmlobj = P_("xml")	

		if not labelArr.exists("data") then
			data = POP_MVC.config("XML_PATH")
		else		
			data = labelArr("data")
			
			if left(data,1) = "$" then
				if isObject( V_( mid(data ,2 ) ) ) then
					set data = V_( mid(data ,2 ) )
				else
					data = V_( mid(data ,2 ) )
				end if			
			end if
		end if
		
		if listType = "file" or listType = "xmlfile" then
			data = sitePath & "/" & POP_MVC.ltrim( data , "/" )
			Call xmlobj.load( data ,"xmlfile")
		elseif listType = "dom" or listType = "xmldocument" then
			Call xmlobj.load( data ,"xmldocument")
		elseif listType = "url" then
			Call xmlobj.load( data ,"transfer")
		end if
		


		'路径
		path = labelArr("path")
		
		if left(path,1) = "$" then
			path = V_( mid(path ,2 ) )
		end if
		
		set  nodes = xmlobj.getNodes(path)
		
		if currentPage = "" then
			currentPage = 1
		end if
		
		perpage = getPageSize( labelArr , 10 )
		
		pageBool = false
		
		set matchesfield = getInnerLabelsDict( loopStr , labelRuleField )

		i = 0
		listIndex = 1
		set fieldArr = D_
		
		for i = 0 to nodes.Length - 1
			if labelArr("page") <> 0 and perpage =  i + 1 and typeIds="" then
				exit for
			end if

			nloopstr=loopStr
			set item = nodes.item(i)
		
			for each k in matchesfield
				set matchfield = matchesfield(k)
				fieldName = matchfield("label")
				if matchfield("attr") <> "" then
					set fieldArr = parseAttr( matchfield("attr") )
				else
					fieldArr.removeAll
				end if

				tempStr = ""
				parseBool = true
				
				'以@开头取属性
				if left(fieldName,1) = "@" then
					attr = mid( fieldName , 2 )
					tempstr = CStr(item.getAttribute(attr))
				else
					select case fieldName
						case "i"  : tempStr = listIndex - (currentPage - 1) * perpage - 1
						case "$" : tempStr = item.text
						case else : 
							set tempstr =item.selectSingleNode(fieldName)
							if not tempstr is nothing then
								tempstr = tempstr.text
							else
								tempstr = ""
							end if
					end select
				end if
				if fieldArr.count > 0 then
					tempStr = FormatTempStr( tempStr , fieldArr , matchfield("full_content") ,item )
				end if
				nloopstr = replaceStr(nloopstr,matchfield("full_content"), tempStr )
			next
			
			if typeIds = "" then
				if i >= (currentPage - 1) * perpage  and i < currentPage * perpage then
					if labelArr("order") = "0" then
						loopstrTotal = nloopstr & loopstrTotal
					else
						loopstrTotal = loopstrTotal & nloopstr
					end if					
				end if			
			else
					if labelArr("order") = "0" then
						loopstrTotal = nloopstr & loopstrTotal
					else
						loopstrTotal = loopstrTotal & nloopstr
					end if	
			end if

		
			listIndex = listIndex + 1
		Next	

	
			set matchesfield = nothing
			replaceContent = replace(replaceContent,matchValue,loopstrTotal)	
			content = replacePageLabel( content , i, labelArr("size")  , currentPage , POP_MVC.get("SortID"), "xml" , POP_MVC.get("template") ,"xml" )			
			content = replacePageList( content , "xml" , i, labelArr("size")  , currentPage , POP_MVC.get("SortID"), "xml" , POP_MVC.get("template") ,"xml" )			
			
		if instr(loopstrTotal,"{" & cmsPrefix & ":sub" & parseListType  )>0 then
			str = "sub"
		else
			if str="" then str=0
			str = str + 1		
		end if
		'if str > 5 then exit function
		
		if instr(loopstrTotal,"{" & cmsPrefix & ":"& str &pageListType)>0 then 		
			set matches = getBlockLabelsDict( loopstrTotal , str &pageListType , ""  )
			for each k in matches					
				set match = matches(k)
				key = match("label")
				matchValue = match("full_content")					
				labelStr = match("attr")								
				loopStr = match("content")		
				Call parseXml( currentPage,pageListType , str )
			next
			set matches = nothing
		end if
		
		'call POP_MVC.cmsPushTime( startTime , "替换标签" & mid( matchValue , 1 , instr(matchValue,"}") )  )
		Call L_( ClassType & ".parseXml " & pageListType )
	End Function
	
	
	'用来替换二维Dictonary对象、二维数组
	'主要针对无限分类数据表与banner展示
	Public Function parseData(ByVal pageListType,typeIds)
		on error resume next
	    dim labelRuleField,labelArr,matchesfield,where,tempStr,str,listIndex,k,pos
	
		Dim loopstrTotal,i,nloopstr,matchfield,fieldNameArr,m,fieldName,fieldArr,namelen,infolen,timestyle,matchesPagelist,matchPagelist,contentlen,pagecontent,typeStr,desclen,m_des,key,item,navListSort,dataIsArray,parseBool,fieldsArr
		Dim attachObj,dataObj,descObj,imageObj
		
		dim startTime : startTime = timer()
		
		labelRuleField = pageListType
		
		'根据不同标签类型，设置不同正则匹配模式
		if pageListType = "navlist" then
			str = typeIds
			labelRuleField = str & pageListType
		end if		

			set where = POP_MVC.SCD
			set labelArr = parseArr(labelStr)	
			listIndex = 1

		if 	pageListType="looparr" then
			if not labelArr.exists(loop4dataName) then
				dataObj = Array()
			else
				dataObj = getArrObj( labelArr , loop4dataName )				
			end if
			
			attachObj = getArrObj( labelArr , loop4keyName )
			descObj = getArrObj( labelArr , "desc" )
			imageObj = getArrObj( labelArr , "image" )
			
			if labelArr.Exists( "start" ) and isNumeric( labelArr("start") ) then
				dataObj = POP_MVC.Arr.Slice( dataObj , Cint(labelArr("start")) - 1 , -1 )
				
				if labelArr.exists(loop4keyName) then
					attachObj = POP_MVC.Arr.Slice( attachObj , Cint(labelArr("start")) - 1 , -1 )
				end if
				
				if labelArr.exists("desc") then
					descObj = POP_MVC.Arr.Slice( descObj , Cint(labelArr("start")) - 1 , -1 )
				end if
				
				if labelArr.exists("image") then
					imageObj = POP_MVC.Arr.Slice( imageObj , Cint(labelArr("start")) - 1 , -1 )
				end if
				
				labelArr.remove("start")
			end if
			
			if labelArr.Exists( "count" ) and not labelArr.Exists( "num" ) then
				labelArr("num") = labelArr("count")
				labelArr.remove("count")
			end if
		elseif 	pageListType="loopdata" then
			if labelArr.exists(loop4dataName) then	
				set dataObj = POP_MVC.tpl_vars( labelArr(loop4dataName) )
			else
				Exit Function
			end if				
		end if
			'set matchesfield = POP_MVC.String.reg_exec(loopStr,labelRuleField,"gim")
 			set matchesfield = getInnerLabelsDict( loopStr , labelRuleField )
			
			if POP_MVC.count( dataObj ) > 0 then
				loopstrTotal = ""
				i = 0
	dataIsArray = false
	if isArray( dataObj ) then
		dataIsArray = true
	end if
	set fieldArr = POP_MVC.SCD

	tempStr = dataObj.keys
	if dataObj.count > 0 then
		fieldsArr = dataObj( tempStr(0) ).keys
	end if
	
		'设置起始i值，默认从1开始
	if labelArr.Exists( "start" ) then
		if is_numeric( labelArr("start") ) then
			for i = 1 to labelArr("start") - 1 
				if dataObj.count > 0 then
					Call POP_MVC.dict.shift( dataObj )
				end if				
			next
		end if
	end if
	i = 0
	'循环每条记录
	for each key in dataObj
		if pageListType <> "looparr" then
			if isObject( dataObj(key) ) then
				set item = dataObj(key)
			else
				item = dataObj(key)
			end if
		elseif pageListType = "looparr" then
			item = key
		end if

		if labelArr.exists("num") then
			if CStr(labelArr("num")) =  CStr(i)  then
				exit for
			end if
		end if
		
		'var_Export item
					
		nloopstr=loopStr
		
		for each k in matchesfield
			set matchfield = matchesfield(k)		

			parseBool = true
			fieldName = matchfield("label")
			if matchfield("attr") <> "" then
				set fieldArr = parseAttr( matchfield("attr") )
			else
				fieldArr.removeAll
			end if	
			
			tempStr = ""
			
		if pageListType="loopdata" then
				select case fieldName
					case "i"	: tempStr = listIndex
					case "_key_"	: tempStr = key
					case "_item_"	: tempStr = item
					case else	: parseBool = true
				End Select
		elseif pageListType="looparr" then
				select case fieldName
					case "i"	: tempStr = listIndex
					case "item",loop4dataName	: tempStr = key
					case loop4keyName	: tempStr = attachObj(i)
					case "desc"	: tempStr = descObj(i)
					case "image"	: tempStr = imageObj(i)
					case else	: parseBool = true
				End Select
		end if
		
	
		
						if not parseBool or pageListType = "loopdata"  then
							pos  = POP_MVC.Arr.iSearch( fieldsArr, fieldName )	
							if pos > -1 then
								parseBool = true
								tempStr = repNull(item(fieldsArr(pos)))
							end if
						end if

						
						if parseBool then							
							if fieldArr.count > 0 then
								tempStr = FormatTempStr( tempStr , fieldArr , matchfield("full_content") ,item )
							end if
							nloopstr = replaceStr(nloopstr,matchfield("full_content"), tempStr )
						elseif not is_empty( POP_MVC.config("SHOW_PAGE_TRACE") )  then
							call POP_MVC.cmsPushTime( 0 , "不能解析标签" & matchfield("full_content") & "，位置：" & "{" & cmsPrefix & ":" & pageListType & " " & labelStr & "}"  )						
						end if		
		
		
					next					
					loopstrTotal = loopstrTotal & nloopstr
					listIndex = listIndex + 1
					i = i +1
				Next				
			end if
			set matchesfield = nothing
			replaceContent = replace(replaceContent,matchValue,loopstrTotal)
			

			set dataObj = nothing
call POP_MVC.cmsPushTime( startTime , "替换标签{" & cmsPrefix & ":"&  pageListType &"}"  )


		Call L_( ClassType & ".parseData " & pageListType )
	End Function
	
	'格式化替换字符串
	'tempStr 字段值
	'fieldArr 属性字典
	'tagContent 标签字符串
	'obj 当前的一条记录
	Public Function FormatTempStr( ByVal tempStr, ByRef fieldArr , ByRef tagContent , ByVal obj )
		on error resume next
		dim str,attrValue,arr,sep,bool,value,result,stype,flag
		sep = "#"
		stype = typename(obj)
		tempStr = repNull(tempStr)
		flag = false
		for each key in fieldArr
			attrValue = fieldArr(key)
			if mid(fieldArr(key),1,1) = "$" and mid(fieldArr(key),1,2) <> "$$" then
				attrValue = trim(mid( fieldArr(key) , 2 ))
				attrValue = V_(attrValue)
			elseif mid(fieldArr(key),1,1) = "@" and fieldArr(key) <> "@me" then
				attrValue = trim(mid( fieldArr(key) , 2 ))
				if stype = "File" or stype = "Folder" then
					Execute( "attrValue = obj." & tempStr )
				else
					attrValue = obj(attrValue)
				end if					
			else
				attrValue = trim(fieldArr(key))
				attrValue = getMvcTplVars(attrValue)
			end if
			
			'对于eq,neq,gt,et
			'使用 eq:结果=值
			if inStr( key , sep ) > 0 then
				arr = split( key, sep )
				key = arr(0)
				result = arr(1)
			end if

			select case key
				case "len"
					'截取字符串，[content:title len=200]
					tempStr = POP_MVC.String.cut( stripTags(tempStr),attrValue )
				case "style"
					if isDate(tempStr) then
						tempStr = POP_MVC.FormatDate( tempStr ,attrValue )
					end if
				case "math"
					if isNum( tempStr ) then
						str = replace( attrValue , "$$" , "tempstr" )
						Execute( "tempStr = " & str )
					end if
				case "selected","checked"
					if CStr(tempStr) = CStr(attrValue) then
						tempStr = key & "=""" & key & """"
					else
						tempStr = ""
					end if
				' eq#className=$_GET.a
				' 判断自身值是否同 POP_MVC.get("a") 是否相等，相等的话返回className
				case "eq"
					tempStr = iif( CStr(tempStr) = CStr(attrValue) , result, "" )
				case "ieq"
					tempStr = iif( LCase(CStr(tempStr)) = LCase(CStr(attrValue)) , result, "" )
				case "neq"
					tempStr = iif( CStr(tempStr) <> CStr(attrValue) , result, "" )
				case "ineq"
					tempStr = iif( LCase(CStr(tempStr)) <> LCase(CStr(attrValue)) , result, "" )
				case "gt"
					tempStr = iif( tempStr - attrValue > 0 , result, "" )
				case "get"
					tempStr = iif( tempStr - attrValue >= 0 , result, "" )
				case "lt"
					tempStr = iif( tempStr - attrValue < 0 , result, "" )
				case "let"
					tempStr = iif( tempStr - attrValue <= 0 , result, "" )
				case "highlight"
					tempStr = replace( tempstr, attrValue , "<span style='color:" & result & "'>" & attrValue & "</span>" )
				case "daydiff"
					if isDate(tempStr) then
						if Datediff("d",Cdate(tempstr),now()) - result <= 0 then
							tempStr = attrValue
							flag = true
						end if
					end if
					if not flag then
						tempStr = ""
					end if
				case "func"
					str = replace( attrValue , """@me""" , "tempStr" )
					str = replace( attrValue , "@me" , "tempStr" )					
					Execute( "tempStr = " & str )
				case "encode"
					if attrValue = "html" then
						tempStr = POP_MVC.String.encodeHtml( tempStr )
					elseif attrValue = "vbs" then
						tempStr = POP_MVC.String.vbsEncode( tempStr )
					elseif attrValue = "json" then
						tempStr = POP_MVC.String.jsonEncode( tempStr )
					elseif attrValue = "url" then
						tempStr = POP_MVC.String.URLEncode( tempStr )
					end if
				case "default"
					if isNul(tempStr) then
						tempStr = fieldArr("default")
						if mid(tempStr,1,1) = "@" then			
							if stype = "File" or stype = "Folder" then
								Execute( "tempStr = obj." & mid(tempStr,2) )
							else
								tempStr = obj( mid(tempStr,2) )
							end if
						else
							tempStr = replace( tempStr, "_EQ_" , "=" )
						end if
					end if				
			end select	
		next
		FormatTempStr = tempStr
		if err.number <> 0 then
			call POP_MVC.cmsPushTime( 0 , "不能解析标签" & tagContent  )		
		end if
	End Function
	
	
	'解析if
	Public Property Get parseIf(x)
		on error resume next
		if instr(content,"{if"&x&":") < 0 then Exit Property	
		dim nextone
		if isnum(x) then
			nextone=Int(x)+1
		else
			nextone=1
		end if

		if inStr(content,"{if"&nextone&":") > 0 then parseIf(nextone)
		dim matchIf,matchesIf,strIf,strThen,strThen1,strElse1,labelRule2,labelRule3
		dim ifFlag,elseIfArray,elseIfSubArray,elseIfArrayLen,resultStr,elseIfLen,strElseIf,strElseIfThen,elseIfFlag
		labelRule="{if"&x&":([\s\S]+?)}([\s\S]*?){end\s+if"&x&"}":labelRule2="{elseif"&x&"":labelRule3="{else}":elseIfFlag=false
		set matchesIf=POP_MVC.String.reg_exec(content,labelRule,"gim")
		for each matchIf in matchesIf 			
			strIf=matchIf.SubMatches(0)
			strIf = getMvcTplVars(strIf)
			
			strThen=matchIf.SubMatches(1)	
			if instr(strThen,labelRule2)>0 then
				elseIfArray=split(strThen,labelRule2):elseIfArrayLen=ubound(elseIfArray):elseIfSubArray=split(elseIfArray(elseIfArrayLen),labelRule3)
				resultStr=elseIfSubArray(1)
				Execute("if "&strIf&" then resultStr=elseIfArray(0)")
				for elseIfLen=1 to elseIfArrayLen-1
					strElseIf=getSubStrByFromAndEnd(elseIfArray(elseIfLen),":","}","")
					strElseIfThen=getSubStrByFromAndEnd(elseIfArray(elseIfLen),"}","","start")
					Execute("if "&strElseIf&" then resultStr=strElseIfThen")
					Execute("if "&strElseIf&" then elseIfFlag=true else  elseIfFlag=false")
					if elseIfFlag then exit for
				next
				
				Execute("if "& getMvcTplVars(getSubStrByFromAndEnd(elseIfSubArray(0),":","}",""))  &" then resultStr=getSubStrByFromAndEnd(elseIfSubArray(0),""}"","""",""start""):elseIfFlag=true")
				content=replace(content,matchIf.value,resultStr)
			else 
				if instr(strThen,"{else}")>0 then 
					strThen1=split(strThen,labelRule3)(0)
					strElse1=split(strThen,labelRule3)(1)
					Execute("if "&strIf&" then ifFlag=true else ifFlag=false")
					if ifFlag then content=replace(content,matchIf.value,strThen1) else content=replace(content,matchIf.value,strElse1)
				else	
					Execute("if "&strIf&" then ifFlag=true else ifFlag=false")
					if ifFlag then content=replace(content,matchIf.value,strThen) else content=replace(content,matchIf.value,"")
				end if
			end if
			elseIfFlag=false
			if err.number <> 0 then
				content=replace(content,matchIf.value,"")
				err.clear
			end if
		next
		set matchesIf=nothing
		Call L_( ClassType & ".parseIf" )
	End Property
	
	'$前缀变量用V_代替
	Function getMvcTplVars( str )
		getMvcTplVars = POP_MVC.String.reg_replace( str ,  "V_(""$1"")"  ,"\" & "$" & "([\w\u0391-\uFFE5]+(?:\.[\w\u0391-\uFFE5]+)?)" , "gim" )
	End Function
	
	Function getSubStrByFromAndEnd(str,startStr,endStr,operType)
		dim location1,location2
		select case operType
			case "start"
				location1=instr(str,startStr)+len(startStr):location2=len(str)+1
			case "end"
				location1=1:location2=instr(location1,str,endStr)
			case else
				location1=instr(str,startStr)+len(startStr):location2=instr(location1,str,endStr)
		end select
		getSubStrByFromAndEnd=mid(str,location1,location2-location1) 
	End Function
	
	
	Function getQQmessage( qqNumber, imgType, className, tip )
		getQQmessage = "<a target='_blank' class='" & className & "' href='http://wpa.qq.com/msgrd?v=3&uin=" & qqNumber & "&site=qq&menu=yes'><img border='0' src='http://wpa.qq.com/pa?p=2:" & qqNumber & ":" & imgType & "' alt='" & tip & "' title='" & tip & "'></a>"
	End Function
	
	Function getWangWangmessage( wwNumber, imgType, className, tip )
		getWangWangmessage = "<a target='_blank' class='" & className & "' href='http://amos1.taobao.com/msg.ww?v=2&uid="& wwNumber & "&s=" & imgType & "'><img border='0' src='http://amos1.taobao.com/online.ww?v=2&uid=" & wwNumber & "&s=" & imgType & "' alt='" & tip & "' /></a>"
	End Function	

	
	'获取可用标签参数
	Public Function parseAttr(Byval attr)
		on error resume next
		dim singleAttr,dict
		set dict = POP_MVC.SCD
		attr = trim(attr)
		if inStr( attr,"=" ) > 0  then
			singleAttr = split( attr, "=" , 2 )
			dict( trim(singleAttr(0)) ) = trim( singleAttr(1) )
		end if
		set parseAttr = dict
		Call L_( ClassType & ".parseAttr" )
	End Function	
	
	'获取可用标签参数
	Public Function parseArr(Byval attr)
		dim attrStr,attrArray,i,singleAttr,singleAttrKey,singleAttrValue,strDictionary
		attrStr = POP_MVC.String.reg_replace(attr,chr(32),"[\s]+","g")
		attrStr = trim(attrStr)
		attrArray = split(attrStr,chr(32))
		
		set strDictionary = POP_MVC.SCD	
		for i=0 to ubound(attrArray)
			singleAttr = split(attrArray(i),chr(61),2)			
			singleAttrKey =  singleAttr(0) : singleAttrValue =  singleAttr(1)
			if not strDictionary.Exists(singleAttrKey) then 
				strDictionary.add singleAttrKey,singleAttrValue 
			else 
				strDictionary(singleAttrKey) = singleAttrValue
			end if
		next
		set parseArr = strDictionary
	End Function	

	
	'获取首页链接
	function getIndexLink
		getIndexLink = left(linkPrefix , len(linkPrefix) - 1 )
	end function

	
	'获取数据表中的title字段值
	Function getDate( ByRef dvalue,ByRef fieldArr )	
		on error resume next
		if Not fieldArr.exists( "style" ) Then 
			tempStr = "m-d"
		else
			tempStr = fieldArr("style")
		end if

		getDate = 	POP_MVC.FormatDate( dvalue ,tempStr)
		Call L_( ClassType & ".getDate" )
	End Function
	
	'获取数据表中的title字段值
	Function getTitle( ByRef title,ByRef labelArr )
		on error resume next
		getTitle = title
		if labelArr.exists("len") then   								
			getTitle = POP_MVC.String.cut( title,labelArr("len") )
		end if	
		Call L_( ClassType & ".getTitle" )
	End Function
	
	'获取模板文件夹路径，如 templates/bbs
	Public Function getTplFolderPath( )
		dim tplPath
		tplPath = POP_MVC.rtrim( templateFile , config.fileExt ) & config.fileExt
		getTplFolderPath =  "templates/" & config.defaultTemplate
		getTplFolderPath = replace( getTplFolderPath , "//" , "/" )
	End Function	
	
	'获取模板路径，如 templates/bbs/html/common/index.html
	Public Function getTemplatePath(  ByRef templateFile  )
		dim tplPath
		tplPath = POP_MVC.rtrim( templateFile , config.fileExt ) & config.fileExt
		getTemplatePath = getTplFolderPath() & "/" & config.htmlFilePath & "/" & tplPath
	End Function
	
	'获取头像个数，如 templates/bbs/res/images/avatar 中 头像图片个数
	Public Function getAvatarCount( stype )
		getAvatarCount = POP_MVC.file.fileCount( getTplFolderPath() & "/res/images/" & stype )
		if stype = "avatar" then
			getAvatarCount = getAvatarCount - 1
		end if
	End Function

	Public Function getTplPath(  ByVal tpl  )
		if tpl = "" Then
			tpl = POP_MVC.c & "/" & POP_MVC.a
		End If
		getTplPath = cms_home_path & "/Tpl/"	& tpl & config.fileExt
	End Function
	
	'是否为数字
	Function isNum(str)
		if not isNul(str) then  isNum=isnumeric(str) else isNum=false
	End Function
	
	Sub initLinkPrefix
		if not isEmpty( linkPrefix ) then Exit Sub
		if config.IsDefault = 1 then
			linkPrefix=sitePath& "/" & "?"
			indexLinkPrefix = sitePath& "/" & POP_MVC.config("INDEX_PAGE") & "?"
			linkPrefix = replace( linkPrefix , "//" , "/" )
		else
			linkPrefix=sitePath & "/" & config.Alias & ".asp?"
			indexLinkPrefix = sitePath& "/" & config.Alias & ".asp?"
			linkPrefix = replace( linkPrefix , "//" , "/" )
		end if
		if indexLinkPrefix = "" then indexLinkPrefix = linkPrefix
		POP_MVC.config("INDEX_LINK_PREFIX") = indexLinkPrefix
		
		'带域名的链接前缀，如：http://127.0.0.1:1251/bbs/
		RealLinkPrefix = POP_MVC.http_host
		RealLinkPrefix = POP_MVC.rtrim(RealLinkPrefix,"/") & linkPrefix
	End Sub

	'将html内容去标签，并按指定长度截取
	Public Function htmlCut( str, len )
		if isNul( str ) then
			htmlCut = ""
			exit function
		end if
		htmlCut = POP_MVC.String.cut( stripTags(str) , Cint(len) * 2 )	
	End Function
	
	'去掉html标签
	Public Function stripTags( str )
		if isNul( str ) then
			stripTags = ""
			Exit Function
		end if
		stripTags = POP_MVC.String.strip_tags(POP_MVC.String.decodeHtml(str) , "html")
	End Function
	
	'根据作者名获取用户ID
	Function getAuthorID( username )
		dim id
		if isEmpty( authorDict ) then
			set authorDict = POP_MVC.SCD	
		end if
		if authorDict.exists( username ) then
			getAuthorID = authorDict( username )
		else
			id = B_( baseTable ).From("User").where( "LoginName='" & username & "'" ).field("UserID").getOne
			if not isNul( id ) then
				authorDict( username ) = id
				getAuthorID = id
			end if			
		end if
	End Function
	
	'获取内部标签，比如[list:title]，x为块标签的文本内容，labelName为标签名，比如list
	'返回二维Dictionary对象
	' dict("flag_start") 	标签左起位置
	' dict("flag_end")		标签结束位置
	' dict("full_content")  整个标签内容，比如[list:title len=30]
	' dict("attr")			标签中的属性，比如[list:title len=30]
	' dict("label")			标签标记，同labelName，如list
	Public Function getInnerLabelsDict( ByRef x , ByRef labelName )
		set getInnerLabelsDict = getInnerLabelsDict_( x , labelName, "[" , "]" )
	End Function
	
	
	'获取内部标签，比如[list:title]，x为块标签的文本内容，labelName为标签名，比如list
	'返回二维Dictionary对象
	' dict("flag_start") 	标签左起位置
	' dict("flag_end")		标签结束位置
	' dict("full_content")  整个标签内容，比如[list:title len=30]
	' dict("attr")			标签中的属性，比如[list:title len=30]
	' dict("label")			标签标记，同labelName，如list
	Public Function getInnerLabelsDict_ ( ByRef x , ByRef labelName , leftLabel, rightLabel )
		dim flag_start,flag_end,space_start,flagStart,startLen
		dim curPos,cusLabel,curFullContent,curAttr
		dim dict,ret,loopMax,loopCnt,prevStart,tempPos
		
		set ret = POP_MVC.SCD
		
		'结束标记
		flagStart = leftLabel & labelName & ":"
		
		'起始标记长度
		startLen = Len(flagStart)	

		curPos = 1
		
		loopMax = 1000
		loopCnt = 0		

		do		
			if loopCnt >= loopMax then
				exit do
			end if
			'左始
			flag_start = inStr( curPos, x, flagStart )
			
			if flag_start < 1 then
				exit do
			end if
			
			'左尾
			flag_end = inStr(flag_start,x,rightLabel)
			
			if flag_end < 1 then
				Me.ShowError4html( "在位置" & flag_start & "处的标签" & mid( x, flag_start , startLen + 100 ) & "……" & "这里未找到闭合标识符的方括号]"  )
				exit do
			end if
			
			'全内容
			curFullContent = mid( x, flag_start, flag_end - flag_start +1  )			
			space_start = instr( startLen  ,curFullContent , " " )
			
			curAttr = ""
			if space_start > 0 then
				curAttr = mid( curFullContent , space_start+ 1 , flag_end - flag_start - space_start )				
				cusLabel = mid( curFullContent , startLen + 1 ,  space_start - startLen -1 )
			else
				cusLabel = mid( curFullContent , startLen + 1 ,  flag_end - flag_start - startLen  )
			end if
			
			set dict = POP_MVC.SCD
			dict("flag_start") = flag_start
			dict("flag_end") = flag_end
			dict("full_content") = curFullContent
			dict("attr") = curAttr
			dict("label") = cusLabel			

			ret.add flag_start , dict

			loopCnt = loopCnt + 1
			curPos = flag_end+1
		loop while curPos > 1

		Call POP_MVC.dict.ksort( ret )
		set getInnerLabelsDict_ = ret
	End Function
	
	
	'获取块标签，比如{iaspcms:list sort=1} ... {/iaspcms:list}
	'x为文档内容，labelName为块标签名，比如list，如果为空，取全部块标签
	'返回二维Dictionary对象
	' dict("left_start")	{iaspcms:list sort=1}开始位置，即{位置
	' dict("left_end")		{iaspcms:list sort=1}结束位置，即}位置
	' dict("right_start")	{/iaspcms:list}开始位置，即{位置
	' dict("right_end")		{/iaspcms:list}结束位置，即}位置
	' dict("full_content")	{iaspcms:list sort=1} ... {/iaspcms:list}块标签全部内容
	' dict("content")		块标签里面的内容
	' dict("attr")			块标签属性字符串，{iaspcms:list sort=1}中的 sort=1
	' dict("label")			块标签标记名，如list
	' dict("is_parse")		是否解析，为０
	' dict("left_flag")		标签的开始标记，如{iaspcms:list sort=1}
	Public Function getBlockLabelsDict( ByRef x , ByVal labelName , ByVal prefix )
		dim left_start,left_end,right_start,right_end,end_len,start_len,left_flag,labelEnd,labelStart
		dim curPos,cusLabel,curFullContent,curAttr,curContent
		dim endLen,startLen
		dim dict,ret,loopMax,loopCnt,prevStart,tempPos,startTime
		
		if isArray(labelName) then
			labelName = join(labelName , ",") & ","
		elseif labelName <> "" then
			labelName = "," & labelName & ","
		end if
		
		startTime = timer
		set ret = POP_MVC.SCD
		
		if prefix = "" then
			prefix = cmsPrefix
		end if
		
		'结束标记
		labelEnd = "{/" & prefix & ":"
		
		'结束标记长度
		endLen = Len(labelEnd)	

		curPos = 1
		prevStart = 1
		
		loopMax = 500
		loopCnt = 0
		
		do		
			if loopCnt >= loopMax then
				exit do
			end if
			'右始
			right_start = inStr( curPos, x, labelEnd )
			
			if right_start < 1 then
				exit do
			end if
			
			'右尾
			right_end = inStr(right_start,x,"}")
			
			if right_end < 1 then
				Me.ShowError4html( "在位置" & right_start & "处的标签" & mid( x, right_start , endLen + 30 ) & "……" & "这里未找到闭合标识符尖括号}"  )
				exit do
			end if
			
			'当前标签名
			cusLabel = mid( x,right_start+endLen,right_end-right_start-endLen )
			
if labelName = "" or inStr(labelName , "," & cusLabel & "," ) > 0 then
			'起始标记
			labelStart = "{" & prefix & ":" & cusLabel
			
			'
			startLen = len( labelStart )
			
			'左始
			left_start = inStrRev( x, labelStart , right_start )
			
			if left_start < 1 then
				Me.ShowError4html( "在位置" & right_start & "处的标签" & labelEnd & cusLabel & "}" & "，未找到对应的起始标签"  )
				exit do
			end if
			

			
			'全内容
			curFullContent = mid( x, left_start, right_end - left_start +1  )

			'左尾
			left_end = inStr( startLen + 1,curFullContent, "}" ) + left_start - 1
			tempPos = inStr( startLen + 1,curFullContent, "{" ) + left_start - 1
			
			if left_end > tempPos then
				Me.ShowError4html( "在块标签中未找到起始标签的}，块标签为：" & curFullContent  )
				exit do
			end if
			
			'left_flag
			left_flag = mid( curFullContent , 1 , left_end - left_start + 1 )
			
			'属性
			curAttr = mid( curFullContent , startLen +1 , left_end - left_start - startLen  )
			
			'标签内的循环内容
			curContent = mid( curFullContent , left_end - left_start + 2 ,right_start - left_end -1)
			
			set dict = POP_MVC.SCD
			dict("left_start") = left_start
			dict("left_end") = left_end
			dict("right_start") = right_start
			dict("right_end") = right_end
			dict("full_content") = curFullContent
			dict("content") = curContent
			dict("attr") = curAttr
			dict("label") = cusLabel
			dict("is_parse") = 0
			dict("left_flag") = left_flag
			

			ret.add left_start , dict
			
end if
			loopCnt = loopCnt + 1
			curPos = right_end+1
		loop while curPos > 1

		POP_MVC.dict.sortByNumeric = True

		Call POP_MVC.dict.ksort( ret )
	
		if not is_empty( POP_MVC.config("SHOW_PAGE_TRACE") ) then
			if isNul( labelName ) then
				Call POP_MVC.cmsPushTime( startTime , "获取 全部块标签("& ret.count &"个) 并转为Dictionary对象" )
			else
				Call POP_MVC.cmsPushTime( startTime , "获取 {/" & prefix & ":" & labelName &  "} 块标签并转为Dictionary对象" )
			end if
		end if

		set getBlockLabelsDict = ret
	End Function

	
	'获取定时发布的where条件
	Function getTimeStatusWhere
		if ClassType = "POPASP_PAPCMS" then
			Exit Function
		end if
		if POP_MVC.config( "DB_TYPE" ) = "access" then
			getTimeStatusWhere = "(TimeStatus = 0  OR ( TimeStatus AND NOT ISNULL( Timeing) AND datediff( ""s"",Timeing , now() ) > 0 ) )"
		elseif POP_MVC.config( "DB_TYPE" ) = "sqlite3" then
			getTimeStatusWhere = "(TimeStatus = 0  OR ( TimeStatus AND Timeing IS NOT NULL AND (JULIANDAY('now') - JULIANDAY( REPLACE( Timeing , '/' , '-' ) )) >= 0) )"
		elseif POP_MVC.config( "DB_TYPE" ) = "mysql" then
			getTimeStatusWhere = "(TimeStatus = 0  OR ( TimeStatus AND NOT ISNULL( Timeing) AND TIMESTAMPDIFF( SECOND,Timeing , now() ) > 0 ) )" 
		end if	
	End Function
	
	'得到 {iaspcms:label} 这样的标签字符串
	Public Property Get getTagLabel( ByRef label )
		getTagLabel = "{" & cmsPrefix & ":" & label & "}"
	End Property	
	
	sub parseExecExp( byref l_d,byref r_d)
		on error resume next
		dim str,matches,match,condition,str_true,str_false,pattern,repStr,pattern1,pos,str1
				
		'表达式运算
		': POP_MVC.String.range( 5,100 )
		'exec_exp
	

		pattern = l_d & "\s*([\:]+)([\s\S]+?)" & r_d
		pattern1 = l_d & "\s*[\:]\$(" & ruleVar & ")\|remove\s*" & r_d

		if POP_MVC.String.reg_test( content, pattern1 , "" ) then
			set matches = POP_MVC.String.reg_exec(content, pattern1  ,"gmi")
			for each match in matches
				pos = inStrRev(  match.subMatches(0), "." )
				if pos then
					str = mid(match.subMatches(0),pos+1)
					str1 = mid(match.subMatches(0),1,pos-1)
					str1= replace( str1, ".",""")("""  )
					str1= "(""" & str1 & """)"
					str = "POP_MVC.tpl_vars" & str1 & ".remove(""" & str & """)"
				else
					str = match.subMatches(0)
					str = "POP_MVC.tpl_vars.remove(""" & str & """)"
				end if
				Execute(  str )
				content = Replace(content,match.value, "" )
			next
		else
			set matches = POP_MVC.String.reg_exec(content, pattern  ,"gm")
			for each match in matches
				str = match.subMatches(1)	
				if match.subMatches(0) = ":" then
					str =  getMvcTplVars( str )
				elseif match.subMatches(0) = "::" then
					'不做任何修改
				end if
				str = replace( str, "V_" , "POP_MVC.tpl_vars" ,1,1,0)
				Execute(  str )
				if err.number <> 0 then
					POP_MVC.error( ClassType & ".parseExecExp:" & "解析 " & match.value & "为" & POP_MVC.String.encodeHtml( str ) & "时不能被Execute,错误：" & err.description )
				end if
				content = Replace(content,match.value, "" )
			next
		end if
		set matches = nothing
		parseExecExp = content	
		Call L_( ClassType & ".parseExecExp" )
	end sub		
	
	'获取项目的文件组织结构图
	function cmsFilesTree
		dim arr,mvcPath,sitePath,adminPath
		mvcPath = POP_MVC.mvc_dir
		adminPath = POP_MVC.file.realDir( mvcPath )
		sitePath = POP_MVC.file.realDir( adminPath )
		arr = array( sitePath & "\Upload" ,sitePath & "\" & staticName , sitePath & "\Templates" , sitePath & "\" & dataName   )
		cmsFilesTree = POP_MVC.file.getFilesMap( sitePath , arr ,-1 )
	end function
	
	'首页链接
	function getHomePage
		dim homePage
		if config.runmode = 1 then
			if config.IsDefault = 1 then		
				homePage = sitePath & "/" 			
			else
				homePage = sitePath & "/" & config.Alias & "/"
			end if
		else
			homePage = sitePath & "/" 													
		end if
		getHomePage = homePage
	end function
	
	function getPageSize( labelArr , num )
		if labelArr.exists("size") then labelArr("num") = labelArr("size")
		if isNul(labelArr("num")) then labelArr("num") = num  else labelArr("num") = cint(labelArr("num"))
		getPageSize = labelArr("num")
	end function
	''''''''''''''''''''''''''''''''''''''''''''''
	
	function getArrItem( ByVal arrStr, num , splitSep )
		num = CInt(num)
		Execute( "arrStr = split( POP_MVC.String.vbsEncode(arrStr) , splitSep ) "  )
		if num >0 and num <= ubound(arrStr) + 1 then
			getArrItem = arrStr( num-1 )
		end if		
	End function

	
	function getArrObj( labelArr,keyName)
		dim splitSep
		splitSep = ","
		if labelArr.Exists("split") then
			splitSep = labelArr("split")
		end if
		if labelArr.exists(keyName) then
			if left(labelArr(keyName),1) = "$" then
				getArrObj = POP_MVC.String.vbsEncode(V_( mid( labelArr(keyName) ,2 ) ))
			elseif POP_MVC.String.reg_test( labelArr(keyName) , "^\w+\.\w+$" , "i" ) then
				Execute( "getArrObj = split( POP_MVC.String.vbsEncode(" & labelArr(keyName) & " ) , splitSep ) "  )
			else
				getArrObj = split( labelArr(keyName) , splitSep )
			end if
		end if
		if not isArray( getArrObj ) then
			getArrObj = split( getArrObj , splitSep )
		end if
	end function		
		
	Public Sub parseAreaList()
		exit sub
	End Sub	
	
	
	
	'替换List循环标签
	Public Function parseList(typeIds,currentPage,ByVal pageListType,keys,showType)	
		on error resume next
	    dim lenPagelist,TypeId,strPagelist,rsObj,labelRulePagelist,labelArr,orderStr,matchesfield,matchfield,spec,aboutkey,where,field,tempStr,tempStr2,arr,msoRs,where2
		Dim loopstrTotal,i,j,nloopstr,fieldName,fieldArr,infolen,matchesPagelist,matchPagelist,searchType,sortType,loopCounter,fieldsArr,parseBool,listIndex,start_,pageSeperator
		Dim tableName
		dim startTime : startTime = timer()		
		labelRulePagelist = "\["&pageListType&":pagenumber([\s\S]*?)\]"
		
		set where = POP_MVC.SCD

		set labelArr = parseArr(labelStr)
		listIndex = 1
					
		if 	pageListType="looprs" then
				if labelArr.exists(loop4dataName) then	
					if POP_MVC.tpl_vars.Exists( labelArr(loop4dataName) ) then
						if typename( POP_MVC.tpl_vars( labelArr(loop4dataName) ) ) = "Recordset" then
							set rsObj = POP_MVC.tpl_vars( labelArr(loop4dataName) )
						end if						
					end if
				end if
				if typename(rsObj) <> "Recordset" then
					Exit Function
				end if
		elseif 	pageListType = CommonTable then
				if labelArr("table") <> "" then
					tableName = labelArr("table")
				else
					tableName = keys				
				end if	
		
				for each tempStr in labelArr
					tempStr2 = labelArr(tempStr)
					if POP_MVC.String.startsWith( tempStr2 , "$" ) then
						tempStr2 = mid(tempStr2,2)
						if POP_MVC.tpl_vars.exists( tempStr2 ) then
							if isObject( POP_MVC.tpl_vars(tempStr2) ) then
								set labelArr( tempStr ) = POP_MVC.tpl_vars( tempStr2 )
							else
								labelArr( tempStr ) = POP_MVC.tpl_vars( tempStr2 )
							end if
						else
							labelArr.remove( tempStr )
						end if
					end if
				next		
				
				for each tempStr in labelArr
					select case tempStr
					case "size"
						B_( tableName ).page( array( currentPage,Cint( labelArr("size") ) ) )
					case "table"
					case "pagelabel"
						showType = labelArr( tempStr )
					case "id"
						typeIds = labelArr( tempStr )
					case else
						execute( "B_(""" & tableName & """)." & tempStr & "( labelArr(tempStr) )" )
					end select
				next
				if not isNul( typeIds ) then
					set rsObj = B_( tableName ).where(typeIds).find
				else
					set rsObj = B_( tableName ).select
				end if
		end if	
		
		if pageListType = CommonTable then
			if isNul(keys) then
				set matchesfield = getInnerLabelsDict( loopStr , CommonTable )
			else
				set matchesfield = getInnerLabelsDict( loopStr , keys )
			end if
		else
			set matchesfield = getInnerLabelsDict( loopStr , pageListType )
		end if
		
		'自定义分页	
		if pageListType <> "looprs" or ( pageListType = "looprs" and labelArr.exists("page") ) then
			listRepContent = replacePageLabel( listRepContent , rsObj.recordCount, rsObj.pagesize, currentPage , TypeIds, pageListType , showType,keys )
		end if
		
		if rsObj.eof then 
			''''
		else

		set fieldArr =	D_
		fieldsArr = P_("recordset").getFields(rsObj)
	
		if not isEmpty(start_) then
			for i = 1 to start_ - 1
				if not rsObj.eof then
					rsObj.moveNext
				end if			
			next
		end if
	
	
		loopstrTotal = ""
		i = 0
		i = Clng(i)	
		
	do while not rsObj.eof  and i < rsObj.pageSize	
		loopCounter = loopCounter + 1
		
		if loopCounter > rsObj.pageSize then
			exit do
		end if
		
		nloopstr=loopStr
		for each k in matchesfield
			parseBool = true
			set matchfield = matchesfield(k)
			
			fieldName = matchfield("label")
			if matchfield("attr") <> "" then
				set fieldArr = parseAttr( matchfield("attr") )
			else
				fieldArr.removeAll
			end if
			
			tempStr = ""

		if pageListType=CommonTable or pageListType="looprs" then
			select case fieldName
				case "i" 	: tempStr = listIndex
				case else	: parseBool = true
			end select
		end if
						if not parseBool or pageListType=CommonTable or pageListType = "looprs" then
							if POP_MVC.arr.iExists( fieldsArr, fieldName) then
								tempStr = repNull(rsObj( fieldName ))
								parseBool = true
							end if
						end if
						
						if parseBool then
							if fieldArr.count > 0 then
								tempStr = FormatTempStr( tempStr , fieldArr , matchfield("full_content") ,rsObj  )
							end if
							nloopstr = replaceStr(nloopstr,matchfield("full_content"), tempStr )
						elseif not is_empty( POP_MVC.config("SHOW_PAGE_TRACE") )  then
							call POP_MVC.cmsPushTime( 0 , "不能解析标签" & matchfield("full_content") & "，位置：" & "{" & cmsPrefix & ":" & pageListType & " " & labelStr & "}"  )						
						end if
					next
					
					loopstrTotal = loopstrTotal & nloopstr
					
					rsObj.movenext
					i = i +1
					listIndex = listIndex + 1
				loop
				
			end if


replaceContent = replace(replaceContent,matchValue,loopstrTotal)

if not is_empty( POP_MVC.config("SHOW_PAGE_TRACE") ) then
	call POP_MVC.cmsPushTime( startTime , "替换标签{" & cmsPrefix & ":" & pageListType & " " & labelStr & "}" )
end if
		
			if  pageListType=CommonTable or pageListType="looprs" then
				dim htmlFileName
				set matchesPagelist = POP_MVC.String.reg_exec(listRepContent,labelRulePagelist,"im")

				for each matchPagelist in matchesPagelist	
					if rsObj.pagecount=0 then
						listRepContent = replace(listRepContent,matchPagelist.value,"")
					else
						lenPagelist = parseArr(matchPagelist.SubMatches(0))("len")
						pageSeperator = parseArr(matchPagelist.SubMatches(0))("sep")
						if not isNul( pageSeperator ) then
							P_("cmspage").seperator = pageSeperator
						end if
						
						if isNul(lenPagelist) then lenPagelist = 10 else lenPagelist = cint(lenPagelist)
						if inStr(TypeIds,",") > 0 then TypeId=split(TypeIds,",")(0) : else TypeId=TypeIds

						Call P_("cmspage").init( rsObj.recordCount, rsObj.pageSize, currentPage , TypeId, pageListType , showType,keys )	
						strPagelist = P_("cmspage").bar( lenPagelist )
						listRepContent = replace(listRepContent,matchPagelist.value,strPagelist)
					end if
				next						
			end if

			rsObj.close: set rsObj = nothing
			set where = nothing
			set labelArr = nothing
			set matchesPagelist = nothing
			set matchesfield = nothing	

		Call L_( typename(Me) & ".parseList" )
	End Function
	
	Function getReplyLink( TopicID,ReplyID,page )
		dim header,url
		
		if guestConfig.ThreadUrlMode = "" then
			header = "?"
		else
			header = "?" & guestConfig.ThreadUrlMode & "_"
		end if
		
		if isNul(page) then
			url = header & TopicID & guestConfig.PageSuffix & "#" & ReplyID
		elseif page=1 or page = 0 then
			url = header & TopicID & guestConfig.PageSuffix & "#" & ReplyID
		else
			url = header & TopicID & "_"  & page & guestConfig.PageSuffix & "#" & ReplyID
		end if	
		getReplyLink = url
	End Function
End Class
%>